-- $Header: /devl/xcs/repo/env/Databases/CAEInterfaces/vhdsclibs/data/simprims/rainier/VITAL/X_RAMB36SDP_EXP.vhd,v 1.3 2010/01/14 19:38:17 fphillip Exp $
-------------------------------------------------------------------------------
-- Copyright (c) 1995/2005 Xilinx, Inc.
-- All Right Reserved.
-------------------------------------------------------------------------------
--   ____  ____
--  /   /\/   /
-- /___/  \  /    Vendor : Xilinx
-- \   \   \/     Version : 11.1
--  \   \         Description : Xilinx Timing Simulation Library Component
--  /   /                  32K-Bit Data and 4K-Bit Parity Dual Port Block RAM
-- /___/   /\     Filename : X_RAMB36SDP_EXP.vhd
-- \   \  /  \    Timestamp : Tues October 18 16:43:59 PST 2005
--  \___\/\___\
--
-- Revision:
--    10/18/05 - Initial version.
--    08/21/06 - Fixed vital delay for vcs_mx (CR 419867).
--    10/02/06 - Added missing path delays for rdrclkl to do and dop (CR 425602).
--    11/02/06 - Fixed sbiterr and dbiterr of ECC (CR 427509).
--    01/04/07 - Added support of memory file to initialize memory and parity (CR 431584).
--    02/21/07 - Added timing check for SSR to RDRCLK (CR 434555).
--    03/14/07 - Removed attribute INITP_FILE (CR 436003).
--    04/03/07 - Changed INIT_FILE = "NONE" as default (CR 436812).
--    08/17/07 - Added setup/hold violation message on address w.r.t. clock (CR 436931).
-- End Revision

----- CELL X_RAMB36SDP_EXP -----

library IEEE;
use IEEE.STD_LOGIC_1164.all;

library STD;
use STD.TEXTIO.all;

library IEEE;
use IEEE.VITAL_Timing.all;

library simprim;
use simprim.Vcomponents.all;
use simprim.VPACKAGE.all;

entity X_RAMB36SDP_EXP is
generic (

    TimingChecksOn : boolean := true;
    InstancePath   : string  := "*";
    Xon            : boolean := true;
    MsgOn          : boolean := true;

    DO_REG : integer := 0;
    EN_ECC_READ : boolean := FALSE;
    EN_ECC_SCRUB : boolean := FALSE;
    EN_ECC_WRITE : boolean := FALSE; 
    INIT : bit_vector := X"000000000000000000";
    INITP_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INITP_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INITP_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INITP_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INITP_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INITP_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INITP_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INITP_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INITP_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INITP_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INITP_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INITP_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INITP_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INITP_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INITP_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INITP_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_40 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_41 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_42 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_43 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_44 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_45 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_46 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_47 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_48 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_49 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_4A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_4B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_4C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_4D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_4E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_4F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_50 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_51 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_52 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_53 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_54 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_55 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_56 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_57 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_58 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_59 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_5A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_5B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_5C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_5D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_5E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_5F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_60 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_61 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_62 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_63 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_64 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_65 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_66 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_67 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_68 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_69 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_6A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_6B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_6C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_6D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_6E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_6F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_70 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_71 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_72 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_73 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_74 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_75 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_76 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_77 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_78 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_79 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_7A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_7B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_7C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_7D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_7E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_7F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
    INIT_FILE : string := "NONE";
    LOC : string := "UNPLACED";
    SETUP_ALL : time := 1000 ps;
    SETUP_READ_FIRST : time := 3000 ps;
    SIM_COLLISION_CHECK : string := "ALL";
    SRVAL : bit_vector := X"000000000000000000";

--- VITAL input wire delays

    tipd_RDADDRL   : VitalDelayArrayType01(15 downto 0) := (others => (0 ps, 0 ps));
    tipd_RDCLKL    : VitalDelayType01                   := ( 0 ps, 0 ps);
    tipd_RDRCLKL    : VitalDelayType01                   := ( 0 ps, 0 ps);
    tipd_DI     : VitalDelayArrayType01(63 downto 0) := (others => (0 ps, 0 ps));
    tipd_DIP    : VitalDelayArrayType01(7 downto 0)  := (others => (0 ps, 0 ps));
    tipd_RDENL     : VitalDelayType01                   := ( 0 ps, 0 ps);
    tipd_REGCEL  : VitalDelayType01                   := ( 0 ps, 0 ps);
    tipd_SSRL    : VitalDelayType01                   := ( 0 ps, 0 ps);

    tipd_WRADDRL   : VitalDelayArrayType01(15 downto 0) := (others => (0 ps, 0 ps));
    tipd_WRCLKL    : VitalDelayType01                   := ( 0 ps, 0 ps);
    tipd_WRENL     : VitalDelayType01                   := ( 0 ps, 0 ps);
    tipd_WEL     : VitalDelayArrayType01 (7 downto 0) := (others => (0 ps, 0 ps));
    

--- VITAL pin-to-pin propagation delays


        
    tpd_RDCLKL_DO  : VitalDelayArrayType01(63 downto 0) := (others => (100 ps, 100 ps));
    tpd_RDRCLKL_DO  : VitalDelayArrayType01(63 downto 0) := (others => (100 ps, 100 ps));
    tpd_RDCLKL_DOP : VitalDelayArrayType01(7 downto 0)  := (others => (100 ps, 100 ps));
    tpd_RDRCLKL_DOP : VitalDelayArrayType01(7 downto 0)  := (others => (100 ps, 100 ps));
    tpd_RDCLKL_DBITERR  : VitalDelayType01 := (100 ps, 100 ps);
    tpd_RDRCLKL_DBITERR  : VitalDelayType01 := (100 ps, 100 ps);
    tpd_RDCLKL_SBITERR  : VitalDelayType01 := (100 ps, 100 ps);
    tpd_RDRCLKL_SBITERR  : VitalDelayType01 := (100 ps, 100 ps);
    tpd_WRCLKL_ECCPARITY : VitalDelayArrayType01(7 downto 0)  := (others => (100 ps, 100 ps));
        
--- VITAL recovery time 


--- VITAL setup time 

    tsetup_RDADDRL_RDCLKL_negedge_posedge  : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
    tsetup_RDADDRL_RDCLKL_posedge_posedge  : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
    tsetup_DI_WRCLKL_negedge_posedge    : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
    tsetup_DI_WRCLKL_posedge_posedge    : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
    tsetup_DIP_WRCLKL_negedge_posedge   : VitalDelayArrayType(7 downto 0)  := (others => 0 ps);
    tsetup_DIP_WRCLKL_posedge_posedge   : VitalDelayArrayType(7 downto 0)  := (others => 0 ps);
    tsetup_RDENL_RDCLKL_negedge_posedge    : VitalDelayType                   := 0 ps;
    tsetup_RDENL_RDCLKL_posedge_posedge    : VitalDelayType                   := 0 ps;
    tsetup_REGCEL_RDCLKL_negedge_posedge : VitalDelayType                   := 0 ps;
    tsetup_REGCEL_RDCLKL_posedge_posedge : VitalDelayType                   := 0 ps;
    tsetup_REGCEL_RDRCLKL_negedge_posedge : VitalDelayType                   := 0 ps;
    tsetup_REGCEL_RDRCLKL_posedge_posedge : VitalDelayType                   := 0 ps;
    tsetup_SSRL_RDCLKL_negedge_posedge   : VitalDelayType                   := 0 ps;
    tsetup_SSRL_RDCLKL_posedge_posedge   : VitalDelayType                   := 0 ps;
    tsetup_SSRL_RDRCLKL_negedge_posedge   : VitalDelayType                   := 0 ps;
    tsetup_SSRL_RDRCLKL_posedge_posedge   : VitalDelayType                   := 0 ps;
    
    tsetup_WRADDRL_WRCLKL_negedge_posedge  : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
    tsetup_WRADDRL_WRCLKL_posedge_posedge  : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
    tsetup_WRENL_WRCLKL_negedge_posedge    : VitalDelayType                   := 0 ps;
    tsetup_WRENL_WRCLKL_posedge_posedge    : VitalDelayType                   := 0 ps;
    tsetup_WEL_WRCLKL_negedge_posedge    : VitalDelayArrayType(7 downto 0)  := (others => 0 ps);
    tsetup_WEL_WRCLKL_posedge_posedge    : VitalDelayArrayType(7 downto 0)  := (others => 0 ps);
    
--- VITAL hold time 

    thold_RDADDRL_RDCLKL_negedge_posedge  : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
    thold_RDADDRL_RDCLKL_posedge_posedge  : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
    thold_DI_WRCLKL_negedge_posedge    : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
    thold_DI_WRCLKL_posedge_posedge    : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
    thold_DIP_WRCLKL_negedge_posedge   : VitalDelayArrayType(7 downto 0)  := (others => 0 ps);
    thold_DIP_WRCLKL_posedge_posedge   : VitalDelayArrayType(7 downto 0)  := (others => 0 ps);
    thold_RDENL_RDCLKL_negedge_posedge    : VitalDelayType                   := 0 ps;
    thold_RDENL_RDCLKL_posedge_posedge    : VitalDelayType                   := 0 ps;
    thold_REGCEL_RDCLKL_negedge_posedge : VitalDelayType                   := 0 ps;
    thold_REGCEL_RDCLKL_posedge_posedge : VitalDelayType                   := 0 ps;
    thold_REGCEL_RDRCLKL_negedge_posedge : VitalDelayType                   := 0 ps;
    thold_REGCEL_RDRCLKL_posedge_posedge : VitalDelayType                   := 0 ps;
    thold_SSRL_RDCLKL_negedge_posedge   : VitalDelayType                   := 0 ps;
    thold_SSRL_RDCLKL_posedge_posedge   : VitalDelayType                   := 0 ps;
    thold_SSRL_RDRCLKL_negedge_posedge   : VitalDelayType                   := 0 ps;
    thold_SSRL_RDRCLKL_posedge_posedge   : VitalDelayType                   := 0 ps;
    
    thold_WRADDRL_WRCLKL_negedge_posedge  : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
    thold_WRADDRL_WRCLKL_posedge_posedge  : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
    thold_WRENL_WRCLKL_negedge_posedge    : VitalDelayType                   := 0 ps;
    thold_WRENL_WRCLKL_posedge_posedge    : VitalDelayType                   := 0 ps;
    thold_WEL_WRCLKL_negedge_posedge    : VitalDelayArrayType(7 downto 0)  := (others => 0 ps);
    thold_WEL_WRCLKL_posedge_posedge    : VitalDelayArrayType(7 downto 0)  := (others => 0 ps);
    

    ticd_RDCLKL          : VitalDelayType                     := 0 ps;
    ticd_RDRCLKL          : VitalDelayType                     := 0 ps;
    tisd_RDADDRL_RDCLKL    : VitalDelayArrayType(15 downto 0)   := (others => 0 ps);
    tisd_DI_WRCLKL      : VitalDelayArrayType(63 downto 0)   := (others => 0 ps);
    tisd_DIP_WRCLKL     : VitalDelayArrayType(7 downto 0)    := (others => 0 ps);
    tisd_RDENL_RDCLKL      : VitalDelayType                     := 0 ps;
    tisd_REGCEL_RDCLKL   : VitalDelayType                     := 0 ps;
    tisd_REGCEL_RDRCLKL   : VitalDelayType                     := 0 ps;
    tisd_SSRL_RDCLKL     : VitalDelayType                     := 0 ps;
    tisd_SSRL_RDRCLKL     : VitalDelayType                     := 0 ps;
    
    ticd_WRCLKL          : VitalDelayType                     := 0 ps;
    tisd_WRADDRL_WRCLKL    : VitalDelayArrayType(15 downto 0)   := (others => 0 ps);
    tisd_WRENL_WRCLKL      : VitalDelayType                     := 0 ps;
    tisd_WEL_WRCLKL      : VitalDelayArrayType(7 downto 0)    := (others => 0 ps);
    
    tperiod_rdclkl_posedge : VitalDelayType := 0 ps;
    tperiod_wrclkl_posedge : VitalDelayType := 0 ps;
    tperiod_rdrclkl_posedge : VitalDelayType := 0 ps;
    
    tpw_RDCLKL_negedge : VitalDelayType := 0 ps;
    tpw_RDCLKL_posedge : VitalDelayType := 0 ps;
    tpw_WRCLKL_negedge : VitalDelayType := 0 ps;
    tpw_WRCLKL_posedge : VitalDelayType := 0 ps;
    tpw_RDRCLKL_negedge : VitalDelayType := 0 ps;
    tpw_RDRCLKL_posedge : VitalDelayType := 0 ps    
    
  );

port (

    DBITERR : out std_ulogic;
    DO : out std_logic_vector(63 downto 0);
    DOP : out std_logic_vector(7 downto 0);
    ECCPARITY : out std_logic_vector(7 downto 0);
    SBITERR : out std_ulogic;
    
    DI : in std_logic_vector(63 downto 0);
    DIP : in std_logic_vector(7 downto 0);
    RDADDRL : in std_logic_vector(15 downto 0);
    RDADDRU : in std_logic_vector(14 downto 0);    
    RDCLKL : in std_ulogic;
    RDCLKU : in std_ulogic;    
    RDENU : in std_ulogic;
    RDENL : in std_ulogic;    
    RDRCLKL : in std_ulogic;
    RDRCLKU : in std_ulogic;    
    REGCEL : in std_ulogic;
    REGCEU : in std_ulogic;    
    SSRL : in std_ulogic;
    SSRU : in std_ulogic;    
    WEL : in std_logic_vector(7 downto 0);
    WEU : in std_logic_vector(7 downto 0);    
    WRADDRL : in std_logic_vector(15 downto 0);
    WRADDRU : in std_logic_vector(14 downto 0);    
    WRCLKL : in std_ulogic;
    WRCLKU : in std_ulogic;    
    WRENL : in std_ulogic;
    WRENU : in std_ulogic    

  );

  attribute VITAL_LEVEL0 of
     X_RAMB36SDP_EXP : entity is true;

end X_RAMB36SDP_EXP;
                                                                        
architecture X_RAMB36SDP_EXP_V of X_RAMB36SDP_EXP is

  attribute VITAL_LEVEL0 of
    X_RAMB36SDP_EXP_V : architecture is true;
  
  component X_ARAMB36_INTERNAL
	generic
	(
          BRAM_MODE : string := "TRUE_DUAL_PORT";
          BRAM_SIZE : integer := 36;
          DOA_REG : integer := 0;
          DOB_REG : integer := 0;
          INIT_A : bit_vector := X"000000000000000000";
          INIT_B : bit_vector := X"000000000000000000";
          RAM_EXTENSION_A : string := "NONE";
          RAM_EXTENSION_B : string := "NONE";
          READ_WIDTH_A : integer := 0;
          READ_WIDTH_B : integer := 0;
          SIM_COLLISION_CHECK : string := "ALL";
          SRVAL_A : bit_vector := X"000000000000000000";
          SRVAL_B : bit_vector := X"000000000000000000";
          WRITE_MODE_A : string := "WRITE_FIRST";
          WRITE_MODE_B : string := "WRITE_FIRST";
          WRITE_WIDTH_A : integer := 0;
          WRITE_WIDTH_B : integer := 0;
          EN_ECC_READ : boolean := FALSE;
          EN_ECC_SCRUB : boolean := FALSE;
          EN_ECC_WRITE : boolean := FALSE;
          SETUP_ALL : time := 1000 ps;
          SETUP_READ_FIRST : time := 3000 ps;
          INIT_FILE : string := "NONE";
          INIT_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_10 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_11 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_12 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_13 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_14 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_15 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_16 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_17 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_18 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_19 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_1A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_1B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_1C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_1D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_1E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_1F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_20 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_21 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_22 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_23 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_24 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_25 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_26 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_27 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_28 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_29 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_2A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_2B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_2C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_2D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_2E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_2F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_30 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_31 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_32 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_33 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_34 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_35 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_36 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_37 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_38 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_39 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_3A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_3B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_3C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_3D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_3E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_3F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_40 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_41 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_42 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_43 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_44 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_45 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_46 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_47 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_48 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_49 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_4A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_4B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_4C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_4D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_4E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_4F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_50 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_51 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_52 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_53 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_54 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_55 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_56 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_57 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_58 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_59 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_5A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_5B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_5C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_5D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_5E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_5F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_60 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_61 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_62 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_63 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_64 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_65 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_66 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_67 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_68 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_69 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_6A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_6B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_6C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_6D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_6E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_6F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_70 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_71 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_72 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_73 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_74 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_75 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_76 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_77 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_78 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_79 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_7A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_7B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_7C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_7D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_7E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INIT_7F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INITP_00 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INITP_01 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INITP_02 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INITP_03 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INITP_04 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INITP_05 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INITP_06 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INITP_07 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INITP_08 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INITP_09 : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INITP_0A : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INITP_0B : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INITP_0C : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INITP_0D : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INITP_0E : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000";
          INITP_0F : bit_vector := X"0000000000000000000000000000000000000000000000000000000000000000"
           );
	port
	(
          CASCADEOUTLATA : out std_ulogic;
          CASCADEOUTLATB : out std_ulogic;
          CASCADEOUTREGA : out std_ulogic;
          CASCADEOUTREGB : out std_ulogic;
          DBITERR : out std_ulogic;
          DOA : out std_logic_vector(63 downto 0);
          DOB : out std_logic_vector(63 downto 0);
          DOPA : out std_logic_vector(7 downto 0);
          DOPB : out std_logic_vector(7 downto 0);
          ECCPARITY : out std_logic_vector(7 downto 0);
          SBITERR : out std_ulogic;
    
          ADDRA : in std_logic_vector(15 downto 0);
          ADDRB : in std_logic_vector(15 downto 0);
          CASCADEINLATA : in std_ulogic;
          CASCADEINLATB : in std_ulogic;
          CASCADEINREGA : in std_ulogic;
          CASCADEINREGB : in std_ulogic;
          CLKA : in std_ulogic;
          CLKB : in std_ulogic;
          DIA : in std_logic_vector(63 downto 0);
          DIB : in std_logic_vector(63 downto 0);
          DIPA : in std_logic_vector(7 downto 0);
          DIPB : in std_logic_vector(7 downto 0);
          ENA : in std_ulogic;
          ENB : in std_ulogic;
          REGCEA : in std_ulogic;
          REGCEB : in std_ulogic;
          REGCLKA : in std_ulogic;
          REGCLKB : in std_ulogic;
          SSRA : in std_ulogic;
          SSRB : in std_ulogic;
          WEA : in std_logic_vector(7 downto 0);
          WEB : in std_logic_vector(7 downto 0)
 	);
  end component;

  
  function GENERICS_STR_BRAM_MODE (
    IN_STR1 : in boolean;
    IN_STR2 : in boolean
    ) return string is
  begin
    if (IN_STR1 = TRUE or IN_STR2 = TRUE) then
      return "ECC";
    else
      return "SIMPLE_DUAL_PORT";
    end if;
  end GENERICS_STR_BRAM_MODE;

  
  signal GND : std_ulogic := '0';
  signal GND_8 : std_logic_vector(7 downto 0) := (others => '0');
  signal GND_64 : std_logic_vector(63 downto 0) := (others => '0');
  signal OPEN_8 : std_logic_vector(7 downto 0);
  signal OPEN_64 : std_logic_vector(63 downto 0);

  constant MAX_ADDR: integer := 15;
  constant MAX_DI:   integer := 63;
  constant MAX_DIP:  integer := 7;
  constant MAX_WE:   integer := 7;
  
  signal RDADDRL_ipd    : std_logic_vector(MAX_ADDR downto 0) := (others => 'X');
  signal RDCLKL_ipd     : std_ulogic                          := 'X';
  signal RDRCLKL_ipd     : std_ulogic                          := 'X';
  signal DI_ipd      : std_logic_vector(MAX_DI  downto 0)  := (others => 'X');
  signal DIP_ipd     : std_logic_vector(MAX_DIP downto 0)  := (others => 'X');
  signal RDENL_ipd      : std_ulogic                          := 'X';
  signal REGCEL_ipd   : std_ulogic                          := 'X';
  signal SSRL_ipd     : std_ulogic                          := 'X';
  signal WEL_ipd      : std_logic_vector(MAX_WE downto 0)   := (others => 'X');    
  signal WRADDRL_ipd    : std_logic_vector(MAX_ADDR downto 0) := (others => 'X');
  signal WRCLKL_ipd     : std_ulogic                          := 'X';
  signal WRENL_ipd      : std_ulogic                          := 'X';

  signal GSR_ipd      : std_ulogic                          := 'X';

  signal GSR_dly      : std_ulogic                          := 'X';

  signal RDADDRL_dly    : std_logic_vector(MAX_ADDR downto 0) := (others => 'X');
  signal RDCLKL_dly     : std_ulogic                          := 'X';
  signal RDRCLKL_dly     : std_ulogic                          := 'X';
  signal DI_dly      : std_logic_vector(MAX_DI downto 0) := (others => 'X');
  signal DIP_dly     : std_logic_vector(MAX_DIP downto 0)  := (others => 'X');
  signal RDENL_dly      : std_ulogic                          := 'X';
  signal GSR_RDCLKL_dly : std_ulogic                          := 'X';
  signal GSR_RDRCLKL_dly : std_ulogic                          := 'X';
  signal REGCEL_dly   : std_ulogic                          := 'X';
  signal SSRL_dly     : std_ulogic                          := 'X';
  signal WEL_dly      : std_logic_vector(MAX_WE downto 0)   := (others => 'X');    
  signal WRADDRL_dly    : std_logic_vector(MAX_ADDR downto 0) := (others => 'X');
  signal WRCLKL_dly     : std_ulogic                          := 'X';
  signal WRENL_dly      : std_ulogic                          := 'X';
  signal GSR_WRCLKL_dly : std_ulogic                          := 'X';
    
  signal DO_zd            : std_logic_vector(MAX_DI downto 0);
  signal DOP_zd           : std_logic_vector(MAX_DIP downto 0);
  signal DOPB_zd           : std_logic_vector(MAX_DIP downto 0);
  signal ECCPARITY_zd           : std_logic_vector(7 downto 0);
  signal DBITERR_zd  : std_ulogic                     := '0';
  signal SBITERR_zd  : std_ulogic                     := '0';

  signal Violation        : std_ulogic                     := '0';


  procedure prcd_warn_msg (
    constant addr_str : in string;
    constant clk_str : in string
    ) is

    variable message : LINE;
    constant MsgSeverity : severity_level := Warning;

  begin
        Write ( message, STRING'(" Setup/Hold Violation on "));
        Write ( message, STRING'(addr_str));
        Write ( message, STRING'(" with respect to "));
        Write ( message, STRING'(clk_str));
        Write ( message, STRING'(" when memory has been enabled. The memory contents at "));
        Write ( message, STRING'(addr_str));
        Write ( message, STRING'(" of the RAM can be corrupted. "));
        Write ( message, STRING'("This corruption is not modeled in this simulation model. Please take the necessary steps to recover from this data corruption in hardware."));
        ASSERT FALSE REPORT message.ALL SEVERITY MsgSeverity;
        DEALLOCATE (message);

  end prcd_warn_msg;

    
begin

  ---------------------
  --  INPUT PATH DELAYs
  --------------------

  WireDelay     : block
  begin

    RDADDRL_DELAY : for i in MAX_ADDR downto 0 generate
      VitalWireDelay (RDADDRL_ipd(i), RDADDRL(i), tipd_RDADDRL(i));
    end generate RDADDRL_DELAY;

    DI_DELAY   : for i in MAX_DI downto 0 generate
      VitalWireDelay (DI_ipd(i), DI(i), tipd_DI(i));
    end generate DI_DELAY;

    DIP_DELAY  : for i in MAX_DIP downto 0 generate
      VitalWireDelay (DIP_ipd(i), DIP(i), tipd_DIP(i));
    end generate DIP_DELAY;

    VitalWireDelay (RDCLKL_ipd, RDCLKL, tipd_RDCLKL);
    VitalWireDelay (RDRCLKL_ipd, RDRCLKL, tipd_RDRCLKL);
    VitalWireDelay (RDENL_ipd, RDENL, tipd_RDENL);
    VitalWireDelay (REGCEL_ipd, REGCEL, tipd_REGCEL);
    VitalWireDelay (SSRL_ipd, SSRL, tipd_SSRL);

    WRADDRL_DELAY : for i in MAX_ADDR downto 0 generate
      VitalWireDelay (WRADDRL_ipd(i), WRADDRL(i), tipd_WRADDRL(i));
    end generate WRADDRL_DELAY;

    WEL_DELAY : for i in  MAX_WE downto 0 GENERATE
      VitalWireDelay (WEL_ipd(i) , WEL(i), tipd_WEL(i));
    end generate WEL_DELAY;

    VitalWireDelay (WRCLKL_ipd, WRCLKL, tipd_WRCLKL);
    VitalWireDelay (WRENL_ipd, WRENL, tipd_WRENL);

----- GSR


  end block;

  SignalDelay   : block
  begin

    RDADDRL_DELAY : for i in MAX_ADDR downto 0 generate
      VitalSignalDelay (RDADDRL_dly(i), RDADDRL_ipd(i), tisd_RDADDRL_RDCLKL(i));
    end generate RDADDRL_DELAY;

    DI_DELAY   : for i in MAX_DI downto 0 generate
      VitalSignalDelay (DI_dly(i), DI_ipd(i), tisd_DI_WRCLKL(i));
    end generate DI_DELAY;

    DIP_DELAY  : for i in MAX_DIP downto 0 generate
      VitalSignalDelay (DIP_dly(i), DIP_ipd(i), tisd_DIP_WRCLKL(i));
    end generate DIP_DELAY;

    VitalSignalDelay (RDCLKL_dly, RDCLKL_ipd, ticd_RDCLKL);
    VitalSignalDelay (RDRCLKL_dly, RDRCLKL_ipd, ticd_RDRCLKL);
    VitalSignalDelay (RDENL_dly, RDENL_ipd, tisd_RDENL_RDCLKL);
    VitalSignalDelay (REGCEL_dly, REGCEL_ipd, tisd_REGCEL_RDCLKL);
    VitalSignalDelay (SSRL_dly, SSRL_ipd, tisd_SSRL_RDCLKL);

    WRADDRL_DELAY : for i in MAX_ADDR downto 0 generate
      VitalSignalDelay (WRADDRL_dly(i), WRADDRL_ipd(i), tisd_WRADDRL_WRCLKL(i));
    end generate WRADDRL_DELAY;

    WEL_DELAY   : for i in MAX_WE downto 0 generate
      VitalSignalDelay (WEL_dly(i), WEL_ipd(i), tisd_WEL_WRCLKL(i));
    end generate WEL_DELAY;

    VitalSignalDelay (WRCLKL_dly, WRCLKL_ipd, ticd_WRCLKL);
    VitalSignalDelay (WRENL_dly, WRENL_ipd, tisd_WRENL_WRCLKL);

  end block;
  
X_RAMB36SDP_EXP_inst : X_ARAMB36_INTERNAL
	generic map (

                INIT_00 => INIT_00,
		INIT_01 => INIT_01,
		INIT_02 => INIT_02,
		INIT_03 => INIT_03,
		INIT_04 => INIT_04,
		INIT_05 => INIT_05,
		INIT_06 => INIT_06,
		INIT_07 => INIT_07,
		INIT_08 => INIT_08,
		INIT_09 => INIT_09,
		INIT_0A => INIT_0A,
		INIT_0B => INIT_0B,
		INIT_0C => INIT_0C,
		INIT_0D => INIT_0D,
		INIT_0E => INIT_0E,
		INIT_0F => INIT_0F,
		INIT_10 => INIT_10,
		INIT_11 => INIT_11,
		INIT_12 => INIT_12,
		INIT_13 => INIT_13,
		INIT_14 => INIT_14,
		INIT_15 => INIT_15,
		INIT_16 => INIT_16,
		INIT_17 => INIT_17,
		INIT_18 => INIT_18,
		INIT_19 => INIT_19,
		INIT_1A => INIT_1A,
		INIT_1B => INIT_1B,
		INIT_1C => INIT_1C,
		INIT_1D => INIT_1D,
		INIT_1E => INIT_1E,
		INIT_1F => INIT_1F,
		INIT_20 => INIT_20,
		INIT_21 => INIT_21,
		INIT_22 => INIT_22,
		INIT_23 => INIT_23,
		INIT_24 => INIT_24,
		INIT_25 => INIT_25,
		INIT_26 => INIT_26,
		INIT_27 => INIT_27,
		INIT_28 => INIT_28,
		INIT_29 => INIT_29,
		INIT_2A => INIT_2A,
		INIT_2B => INIT_2B,
		INIT_2C => INIT_2C,
		INIT_2D => INIT_2D,
		INIT_2E => INIT_2E,
		INIT_2F => INIT_2F,
		INIT_30 => INIT_30,
		INIT_31 => INIT_31,
		INIT_32 => INIT_32,
		INIT_33 => INIT_33,
		INIT_34 => INIT_34,
		INIT_35 => INIT_35,
		INIT_36 => INIT_36,
		INIT_37 => INIT_37,
		INIT_38 => INIT_38,
		INIT_39 => INIT_39,
		INIT_3A => INIT_3A,
		INIT_3B => INIT_3B,
		INIT_3C => INIT_3C,
		INIT_3D => INIT_3D,
		INIT_3E => INIT_3E,
		INIT_3F => INIT_3F,
		INIT_40 => INIT_40,
		INIT_41 => INIT_41,
		INIT_42 => INIT_42,
		INIT_43 => INIT_43,
		INIT_44 => INIT_44,
		INIT_45 => INIT_45,
		INIT_46 => INIT_46,
		INIT_47 => INIT_47,
		INIT_48 => INIT_48,
		INIT_49 => INIT_49,
		INIT_4A => INIT_4A,
		INIT_4B => INIT_4B,
		INIT_4C => INIT_4C,
		INIT_4D => INIT_4D,
		INIT_4E => INIT_4E,
		INIT_4F => INIT_4F,
		INIT_50 => INIT_50,
		INIT_51 => INIT_51,
		INIT_52 => INIT_52,
		INIT_53 => INIT_53,
		INIT_54 => INIT_54,
		INIT_55 => INIT_55,
		INIT_56 => INIT_56,
		INIT_57 => INIT_57,
		INIT_58 => INIT_58,
		INIT_59 => INIT_59,
		INIT_5A => INIT_5A,
		INIT_5B => INIT_5B,
		INIT_5C => INIT_5C,
		INIT_5D => INIT_5D,
		INIT_5E => INIT_5E,
		INIT_5F => INIT_5F,
		INIT_60 => INIT_60,
		INIT_61 => INIT_61,
		INIT_62 => INIT_62,
		INIT_63 => INIT_63,
		INIT_64 => INIT_64,
		INIT_65 => INIT_65,
		INIT_66 => INIT_66,
		INIT_67 => INIT_67,
		INIT_68 => INIT_68,
		INIT_69 => INIT_69,
		INIT_6A => INIT_6A,
		INIT_6B => INIT_6B,
		INIT_6C => INIT_6C,
		INIT_6D => INIT_6D,
		INIT_6E => INIT_6E,
		INIT_6F => INIT_6F,
		INIT_70 => INIT_70,
		INIT_71 => INIT_71,
		INIT_72 => INIT_72,
		INIT_73 => INIT_73,
		INIT_74 => INIT_74,
		INIT_75 => INIT_75,
		INIT_76 => INIT_76,
		INIT_77 => INIT_77,
		INIT_78 => INIT_78,
		INIT_79 => INIT_79,
		INIT_7A => INIT_7A,
		INIT_7B => INIT_7B,
		INIT_7C => INIT_7C,
		INIT_7D => INIT_7D,
		INIT_7E => INIT_7E,
		INIT_7F => INIT_7F,
                
		INITP_00 => INITP_00,
		INITP_01 => INITP_01,
		INITP_02 => INITP_02,
		INITP_03 => INITP_03,
		INITP_04 => INITP_04,
		INITP_05 => INITP_05,
		INITP_06 => INITP_06,
		INITP_07 => INITP_07,
		INITP_08 => INITP_08,
		INITP_09 => INITP_09,
		INITP_0A => INITP_0A,
		INITP_0B => INITP_0B,
		INITP_0C => INITP_0C,
		INITP_0D => INITP_0D,
		INITP_0E => INITP_0E,
		INITP_0F => INITP_0F,

		INIT_A  => INIT,
		INIT_B  => INIT,
                INIT_FILE => INIT_FILE,
		SIM_COLLISION_CHECK => SIM_COLLISION_CHECK,
		SRVAL_A => SRVAL,
		SRVAL_B => SRVAL,
		WRITE_MODE_A => "READ_FIRST",
		WRITE_MODE_B => "READ_FIRST",                
                BRAM_MODE => GENERICS_STR_BRAM_MODE(EN_ECC_WRITE, EN_ECC_READ),
                EN_ECC_READ => EN_ECC_READ,
                EN_ECC_WRITE => EN_ECC_WRITE,
                EN_ECC_SCRUB => EN_ECC_SCRUB,
                DOA_REG => DO_REG,
                DOB_REG => DO_REG,
                SETUP_ALL => SETUP_ALL,
                SETUP_READ_FIRST => SETUP_READ_FIRST,
                READ_WIDTH_A => 72,
                READ_WIDTH_B => 72,                
                WRITE_WIDTH_A => 72,
                WRITE_WIDTH_B => 72          
                )
  
        port map (
                ADDRA => RDADDRL_dly,
                ADDRB => WRADDRL_dly,
                CLKA => RDCLKL_dly,
                CLKB => WRCLKL_dly,
                DIA => GND_64,
                DIB => DI_dly,
                DIPA => GND_8,
                DIPB => DIP_dly,
                ENA => RDENL_dly,
                ENB => WRENL_dly,
                SSRA => SSRL_dly,
                SSRB => GND,
                WEA => GND_8,
                WEB => WEL_dly,
                DOA => DO_zd,
                DOB => OPEN_64,
                DOPA => DOP_zd,
                DOPB => OPEN_8,
                CASCADEOUTLATA => OPEN,
                CASCADEOUTLATB => OPEN,
                CASCADEOUTREGA => OPEN,
                CASCADEOUTREGB => OPEN,
                CASCADEINLATA => GND,
                CASCADEINLATB => GND,
                CASCADEINREGA => GND,
                CASCADEINREGB => GND,
                REGCLKA => RDRCLKL_dly,
                REGCLKB => GND,
                REGCEA => REGCEL_dly,
                REGCEB => GND,
                DBITERR => DBITERR_zd,
                SBITERR => SBITERR_zd,
                ECCPARITY => ECCPARITY_zd
        );

-------------------------------------------------------------------------------
-- Timing check
-------------------------------------------------------------------------------
  process

    variable Tviol_RDADDRL0_RDCLKL_posedge  : std_ulogic := '0';
    variable Tviol_RDADDRL1_RDCLKL_posedge  : std_ulogic := '0';
    variable Tviol_RDADDRL2_RDCLKL_posedge  : std_ulogic := '0';
    variable Tviol_RDADDRL3_RDCLKL_posedge  : std_ulogic := '0';
    variable Tviol_RDADDRL4_RDCLKL_posedge  : std_ulogic := '0';
    variable Tviol_RDADDRL5_RDCLKL_posedge  : std_ulogic := '0';
    variable Tviol_RDADDRL6_RDCLKL_posedge  : std_ulogic := '0';
    variable Tviol_RDADDRL7_RDCLKL_posedge  : std_ulogic := '0';
    variable Tviol_RDADDRL8_RDCLKL_posedge  : std_ulogic := '0';
    variable Tviol_RDADDRL9_RDCLKL_posedge  : std_ulogic := '0';
    variable Tviol_RDADDRL10_RDCLKL_posedge : std_ulogic := '0';
    variable Tviol_RDADDRL11_RDCLKL_posedge : std_ulogic := '0';
    variable Tviol_RDADDRL12_RDCLKL_posedge : std_ulogic := '0';
    variable Tviol_RDADDRL13_RDCLKL_posedge : std_ulogic := '0';
    variable Tviol_RDADDRL14_RDCLKL_posedge : std_ulogic := '0';
    variable Tviol_RDADDRL15_RDCLKL_posedge : std_ulogic := '0';
    variable Tviol_DI0_WRCLKL_posedge    : std_ulogic := '0';
    variable Tviol_DI1_WRCLKL_posedge    : std_ulogic := '0';
    variable Tviol_DI2_WRCLKL_posedge    : std_ulogic := '0';
    variable Tviol_DI3_WRCLKL_posedge    : std_ulogic := '0';
    variable Tviol_DI4_WRCLKL_posedge    : std_ulogic := '0';
    variable Tviol_DI5_WRCLKL_posedge    : std_ulogic := '0';
    variable Tviol_DI6_WRCLKL_posedge    : std_ulogic := '0';
    variable Tviol_DI7_WRCLKL_posedge    : std_ulogic := '0';
    variable Tviol_DI8_WRCLKL_posedge    : std_ulogic := '0';
    variable Tviol_DI9_WRCLKL_posedge    : std_ulogic := '0';
    variable Tviol_DI10_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI11_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI12_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI13_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI14_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI15_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI16_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI17_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI18_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI19_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI20_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI21_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI22_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI23_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI24_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI25_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI26_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI27_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI28_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI29_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI30_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI31_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI32_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI33_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI34_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI35_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI36_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI37_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI38_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI39_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI40_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI41_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI42_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI43_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI44_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI45_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI46_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI47_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI48_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI49_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI50_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI51_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI52_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI53_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI54_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI55_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI56_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI57_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI58_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI59_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI60_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI61_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI62_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DI63_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DIP0_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DIP1_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DIP2_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DIP3_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DIP4_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DIP5_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DIP6_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_DIP7_WRCLKL_posedge   : std_ulogic := '0';
    variable Tviol_RDENL_RDCLKL_posedge     : std_ulogic := '0';
    variable Tviol_SSRL_RDCLKL_posedge    : std_ulogic := '0';
    variable Tviol_SSRL_RDRCLKL_posedge    : std_ulogic := '0';
    variable Tviol_REGCEL_RDCLKL_posedge    : std_ulogic := '0';
    variable Tviol_REGCEL_RDRCLKL_posedge    : std_ulogic := '0';

    variable Tviol_WRADDRL0_WRCLKL_posedge  : std_ulogic := '0';
    variable Tviol_WRADDRL1_WRCLKL_posedge  : std_ulogic := '0';
    variable Tviol_WRADDRL2_WRCLKL_posedge  : std_ulogic := '0';
    variable Tviol_WRADDRL3_WRCLKL_posedge  : std_ulogic := '0';
    variable Tviol_WRADDRL4_WRCLKL_posedge  : std_ulogic := '0';
    variable Tviol_WRADDRL5_WRCLKL_posedge  : std_ulogic := '0';
    variable Tviol_WRADDRL6_WRCLKL_posedge  : std_ulogic := '0';
    variable Tviol_WRADDRL7_WRCLKL_posedge  : std_ulogic := '0';
    variable Tviol_WRADDRL8_WRCLKL_posedge  : std_ulogic := '0';
    variable Tviol_WRADDRL9_WRCLKL_posedge  : std_ulogic := '0';
    variable Tviol_WRADDRL10_WRCLKL_posedge : std_ulogic := '0';
    variable Tviol_WRADDRL11_WRCLKL_posedge : std_ulogic := '0';
    variable Tviol_WRADDRL12_WRCLKL_posedge : std_ulogic := '0';
    variable Tviol_WRADDRL13_WRCLKL_posedge : std_ulogic := '0';
    variable Tviol_WRADDRL14_WRCLKL_posedge : std_ulogic := '0';
    variable Tviol_WRADDRL15_WRCLKL_posedge : std_ulogic := '0';
    variable Tviol_WRENL_WRCLKL_posedge     : std_ulogic := '0';
    variable Tviol_WEL0_WRCLKL_posedge    : std_ulogic := '0';
    variable Tviol_WEL1_WRCLKL_posedge    : std_ulogic := '0';
    variable Tviol_WEL2_WRCLKL_posedge    : std_ulogic := '0';
    variable Tviol_WEL3_WRCLKL_posedge    : std_ulogic := '0';
    variable Tviol_WEL4_WRCLKL_posedge    : std_ulogic := '0';
    variable Tviol_WEL5_WRCLKL_posedge    : std_ulogic := '0';
    variable Tviol_WEL6_WRCLKL_posedge    : std_ulogic := '0';
    variable Tviol_WEL7_WRCLKL_posedge    : std_ulogic := '0';
    
    variable Tviol_RDCLKL_WRCLKL_all        : std_ulogic := '0';
    variable Tviol_RDCLKL_WRCLKL_read_first : std_ulogic := '0';
    variable Tviol_WRCLKL_RDCLKL_all        : std_ulogic := '0';
    variable Tviol_WRCLKL_RDCLKL_read_first : std_ulogic := '0';

    variable Tmkr_RDADDRL0_RDCLKL_posedge   : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_RDADDRL1_RDCLKL_posedge   : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_RDADDRL2_RDCLKL_posedge   : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_RDADDRL3_RDCLKL_posedge   : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_RDADDRL4_RDCLKL_posedge   : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_RDADDRL5_RDCLKL_posedge   : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_RDADDRL6_RDCLKL_posedge   : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_RDADDRL7_RDCLKL_posedge   : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_RDADDRL8_RDCLKL_posedge   : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_RDADDRL9_RDCLKL_posedge   : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_RDADDRL10_RDCLKL_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_RDADDRL11_RDCLKL_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_RDADDRL12_RDCLKL_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_RDADDRL13_RDCLKL_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_RDADDRL14_RDCLKL_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_RDADDRL15_RDCLKL_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI0_WRCLKL_posedge     : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI1_WRCLKL_posedge     : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI2_WRCLKL_posedge     : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI3_WRCLKL_posedge     : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI4_WRCLKL_posedge     : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI5_WRCLKL_posedge     : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI6_WRCLKL_posedge     : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI7_WRCLKL_posedge     : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI8_WRCLKL_posedge     : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI9_WRCLKL_posedge     : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI10_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI11_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI12_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI13_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI14_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI15_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI16_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI17_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI18_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI19_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI20_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI21_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI22_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI23_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI24_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI25_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI26_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI27_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI28_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI29_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI30_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI31_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI32_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI33_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI34_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI35_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI36_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI37_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI38_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI39_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI40_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI41_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI42_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI43_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI44_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI45_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI46_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI47_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI48_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI49_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;    
    variable Tmkr_DI50_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI51_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI52_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI53_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI54_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI55_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI56_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI57_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI58_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI59_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI60_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI61_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI62_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DI63_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DIP0_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DIP1_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DIP2_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DIP3_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DIP4_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DIP5_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DIP6_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_DIP7_WRCLKL_posedge    : VitalTimingDataType := VitalTimingDataInit;    
    variable Tmkr_RDENL_RDCLKL_posedge      : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_SSRL_RDCLKL_posedge     : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_SSRL_RDRCLKL_posedge     : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_REGCEL_RDCLKL_posedge     : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_REGCEL_RDRCLKL_posedge     : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_WEL0_WRCLKL_posedge      : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_WEL1_WRCLKL_posedge      : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_WEL2_WRCLKL_posedge      : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_WEL3_WRCLKL_posedge      : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_WEL4_WRCLKL_posedge      : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_WEL5_WRCLKL_posedge      : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_WEL6_WRCLKL_posedge      : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_WEL7_WRCLKL_posedge      : VitalTimingDataType := VitalTimingDataInit;
        
    variable Tmkr_WRADDRL0_WRCLKL_posedge   : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_WRADDRL1_WRCLKL_posedge   : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_WRADDRL2_WRCLKL_posedge   : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_WRADDRL3_WRCLKL_posedge   : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_WRADDRL4_WRCLKL_posedge   : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_WRADDRL5_WRCLKL_posedge   : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_WRADDRL6_WRCLKL_posedge   : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_WRADDRL7_WRCLKL_posedge   : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_WRADDRL8_WRCLKL_posedge   : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_WRADDRL9_WRCLKL_posedge   : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_WRADDRL10_WRCLKL_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_WRADDRL11_WRCLKL_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_WRADDRL12_WRCLKL_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_WRADDRL13_WRCLKL_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_WRADDRL14_WRCLKL_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_WRADDRL15_WRCLKL_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_WRENL_WRCLKL_posedge      : VitalTimingDataType := VitalTimingDataInit;

    variable Tmkr_RDCLKL_WRCLKL_all        : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_RDCLKL_WRCLKL_read_first : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_WRCLKL_RDCLKL_all        : VitalTimingDataType := VitalTimingDataInit;
    variable Tmkr_WRCLKL_RDCLKL_read_first : VitalTimingDataType := VitalTimingDataInit;

    variable PViol_RDCLKL, PViol_RDRCLKL, PViol_WRCLKL : std_ulogic          := '0';
    variable PInfo_RDCLKL, PInfo_RDRCLKL, PInfo_WRCLKL : VitalPeriodDataType := VitalPeriodDataInit;
    
  begin  -- process
    if (TimingChecksOn) then
      VitalSetupHoldCheck (
        Violation      => Tviol_RDENL_RDCLKL_posedge,
        TimingData     => Tmkr_RDENL_RDCLKL_posedge,
        TestSignal     => RDENL_dly,
        TestSignalName => "RDENL",
        TestDelay      => tisd_RDENL_RDCLKL,
        RefSignal      => RDCLKL_dly,
        RefSignalName  => "RDCLKL",
        RefDelay       => ticd_RDCLKL,
        SetupHigh      => tsetup_RDENL_RDCLKL_posedge_posedge,
        SetupLow       => tsetup_RDENL_RDCLKL_negedge_posedge,
        HoldLow        => thold_RDENL_RDCLKL_negedge_posedge,
        HoldHigh       => thold_RDENL_RDCLKL_posedge_posedge,
        CheckEnabled   => true,
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_SSRL_RDCLKL_posedge,
        TimingData     => Tmkr_SSRL_RDCLKL_posedge,
        TestSignal     => SSRL_dly,
        TestSignalName => "SSRL",
        TestDelay      => tisd_SSRL_RDCLKL,
        RefSignal      => RDCLKL_dly,
        RefSignalName  => "RDCLKL",
        RefDelay       => ticd_RDCLKL,
        SetupHigh      => tsetup_SSRL_RDCLKL_posedge_posedge,
        SetupLow       => tsetup_SSRL_RDCLKL_negedge_posedge,
        HoldLow        => thold_SSRL_RDCLKL_negedge_posedge,
        HoldHigh       => thold_SSRL_RDCLKL_posedge_posedge,
        CheckEnabled   => TO_X01(rdenl_dly) = '1',
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_SSRL_RDRCLKL_posedge,
        TimingData     => Tmkr_SSRL_RDRCLKL_posedge,
        TestSignal     => SSRL_dly,
        TestSignalName => "SSRL",
        TestDelay      => tisd_SSRL_RDRCLKL,
        RefSignal      => RDRCLKL_dly,
        RefSignalName  => "RDRCLKL",
        RefDelay       => ticd_RDRCLKL,
        SetupHigh      => tsetup_SSRL_RDRCLKL_posedge_posedge,
        SetupLow       => tsetup_SSRL_RDRCLKL_negedge_posedge,
        HoldLow        => thold_SSRL_RDRCLKL_negedge_posedge,
        HoldHigh       => thold_SSRL_RDRCLKL_posedge_posedge,
        CheckEnabled   => TO_X01(rdenl_dly) = '1',
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_REGCEL_RDCLKL_posedge,
        TimingData     => Tmkr_REGCEL_RDCLKL_posedge,
        TestSignal     => REGCEL_dly,
        TestSignalName => "REGCEL",
        TestDelay      => tisd_REGCEL_RDCLKL,
        RefSignal      => RDCLKL_dly,
        RefSignalName  => "RDCLKL",
        RefDelay       => ticd_RDCLKL,
        SetupHigh      => tsetup_REGCEL_RDCLKL_posedge_posedge,
        SetupLow       => tsetup_REGCEL_RDCLKL_negedge_posedge,
        HoldLow        => thold_REGCEL_RDCLKL_negedge_posedge,
        HoldHigh       => thold_REGCEL_RDCLKL_posedge_posedge,
        CheckEnabled   => TO_X01(rdenl_dly) = '1',
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_REGCEL_RDRCLKL_posedge,
        TimingData     => Tmkr_REGCEL_RDRCLKL_posedge,
        TestSignal     => REGCEL_dly,
        TestSignalName => "REGCEL",
        TestDelay      => tisd_REGCEL_RDRCLKL,
        RefSignal      => RDRCLKL_dly,
        RefSignalName  => "RDRCLKL",
        RefDelay       => ticd_RDRCLKL,
        SetupHigh      => tsetup_REGCEL_RDRCLKL_posedge_posedge,
        SetupLow       => tsetup_REGCEL_RDRCLKL_negedge_posedge,
        HoldLow        => thold_REGCEL_RDRCLKL_negedge_posedge,
        HoldHigh       => thold_REGCEL_RDRCLKL_posedge_posedge,
        CheckEnabled   => TO_X01(rdenl_dly) = '1',
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_RDADDRL0_RDCLKL_posedge,
        TimingData     => Tmkr_RDADDRL0_RDCLKL_posedge,
        TestSignal     => RDADDRL_dly(0),
        TestSignalName => "RDADDRL(0)",
        TestDelay      => tisd_RDADDRL_RDCLKL(0),
        RefSignal      => RDCLKL_dly,
        RefSignalName  => "RDCLKL",
        RefDelay       => ticd_RDCLKL,
        SetupHigh      => tsetup_RDADDRL_RDCLKL_posedge_posedge(0),
        SetupLow       => tsetup_RDADDRL_RDCLKL_negedge_posedge(0),
        HoldLow        => thold_RDADDRL_RDCLKL_negedge_posedge(0),
        HoldHigh       => thold_RDADDRL_RDCLKL_posedge_posedge(0),
        CheckEnabled   => TO_X01(rdenl_dly) = '1',
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_RDADDRL1_RDCLKL_posedge,
        TimingData     => Tmkr_RDADDRL1_RDCLKL_posedge,
        TestSignal     => RDADDRL_dly(1),
        TestSignalName => "RDADDRL(1)",
        TestDelay      => tisd_RDADDRL_RDCLKL(1),
        RefSignal      => RDCLKL_dly,
        RefSignalName  => "RDCLKL",
        RefDelay       => ticd_RDCLKL,
        SetupHigh      => tsetup_RDADDRL_RDCLKL_posedge_posedge(1),
        SetupLow       => tsetup_RDADDRL_RDCLKL_negedge_posedge(1),
        HoldLow        => thold_RDADDRL_RDCLKL_negedge_posedge(1),
        HoldHigh       => thold_RDADDRL_RDCLKL_posedge_posedge(1),
        CheckEnabled   => TO_X01(rdenl_dly) = '1',
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_RDADDRL2_RDCLKL_posedge,
        TimingData     => Tmkr_RDADDRL2_RDCLKL_posedge,
        TestSignal     => RDADDRL_dly(2),
        TestSignalName => "RDADDRL(2)",
        TestDelay      => tisd_RDADDRL_RDCLKL(2),
        RefSignal      => RDCLKL_dly,
        RefSignalName  => "RDCLKL",
        RefDelay       => ticd_RDCLKL,
        SetupHigh      => tsetup_RDADDRL_RDCLKL_posedge_posedge(2),
        SetupLow       => tsetup_RDADDRL_RDCLKL_negedge_posedge(2),
        HoldLow        => thold_RDADDRL_RDCLKL_negedge_posedge(2),
        HoldHigh       => thold_RDADDRL_RDCLKL_posedge_posedge(2),
        CheckEnabled   => TO_X01(rdenl_dly) = '1',
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_RDADDRL3_RDCLKL_posedge,
        TimingData     => Tmkr_RDADDRL3_RDCLKL_posedge,
        TestSignal     => RDADDRL_dly(3),
        TestSignalName => "RDADDRL(3)",
        TestDelay      => tisd_RDADDRL_RDCLKL(3),
        RefSignal      => RDCLKL_dly,
        RefSignalName  => "RDCLKL",
        RefDelay       => ticd_RDCLKL,
        SetupHigh      => tsetup_RDADDRL_RDCLKL_posedge_posedge(3),
        SetupLow       => tsetup_RDADDRL_RDCLKL_negedge_posedge(3),
        HoldLow        => thold_RDADDRL_RDCLKL_negedge_posedge(3),
        HoldHigh       => thold_RDADDRL_RDCLKL_posedge_posedge(3),
        CheckEnabled   => TO_X01(rdenl_dly) = '1',
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_RDADDRL4_RDCLKL_posedge,
        TimingData     => Tmkr_RDADDRL4_RDCLKL_posedge,
        TestSignal     => RDADDRL_dly(4),
        TestSignalName => "RDADDRL(4)",
        TestDelay      => tisd_RDADDRL_RDCLKL(4),
        RefSignal      => RDCLKL_dly,
        RefSignalName  => "RDCLKL",
        RefDelay       => ticd_RDCLKL,
        SetupHigh      => tsetup_RDADDRL_RDCLKL_posedge_posedge(4),
        SetupLow       => tsetup_RDADDRL_RDCLKL_negedge_posedge(4),
        HoldLow        => thold_RDADDRL_RDCLKL_negedge_posedge(4),
        HoldHigh       => thold_RDADDRL_RDCLKL_posedge_posedge(4),
        CheckEnabled   => TO_X01(rdenl_dly) = '1',
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_RDADDRL5_RDCLKL_posedge,
        TimingData     => Tmkr_RDADDRL5_RDCLKL_posedge,
        TestSignal     => RDADDRL_dly(5),
        TestSignalName => "RDADDRL(5)",
        TestDelay      => tisd_RDADDRL_RDCLKL(5),
        RefSignal      => RDCLKL_dly,
        RefSignalName  => "RDCLKL",
        RefDelay       => ticd_RDCLKL,
        SetupHigh      => tsetup_RDADDRL_RDCLKL_posedge_posedge(5),
        SetupLow       => tsetup_RDADDRL_RDCLKL_negedge_posedge(5),
        HoldLow        => thold_RDADDRL_RDCLKL_negedge_posedge(5),
        HoldHigh       => thold_RDADDRL_RDCLKL_posedge_posedge(5),
        CheckEnabled   => TO_X01(rdenl_dly) = '1',
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_RDADDRL6_RDCLKL_posedge,
        TimingData     => Tmkr_RDADDRL6_RDCLKL_posedge,
        TestSignal     => RDADDRL_dly(6),
        TestSignalName => "RDADDRL(6)",
        TestDelay      => tisd_RDADDRL_RDCLKL(6),
        RefSignal      => RDCLKL_dly,
        RefSignalName  => "RDCLKL",
        RefDelay       => ticd_RDCLKL,
        SetupHigh      => tsetup_RDADDRL_RDCLKL_posedge_posedge(6),
        SetupLow       => tsetup_RDADDRL_RDCLKL_negedge_posedge(6),
        HoldLow        => thold_RDADDRL_RDCLKL_negedge_posedge(6),
        HoldHigh       => thold_RDADDRL_RDCLKL_posedge_posedge(6),
        CheckEnabled   => TO_X01(rdenl_dly) = '1',
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_RDADDRL7_RDCLKL_posedge,
        TimingData     => Tmkr_RDADDRL7_RDCLKL_posedge,
        TestSignal     => RDADDRL_dly(7),
        TestSignalName => "RDADDRL(7)",
        TestDelay      => tisd_RDADDRL_RDCLKL(7),
        RefSignal      => RDCLKL_dly,
        RefSignalName  => "RDCLKL",
        RefDelay       => ticd_RDCLKL,
        SetupHigh      => tsetup_RDADDRL_RDCLKL_posedge_posedge(7),
        SetupLow       => tsetup_RDADDRL_RDCLKL_negedge_posedge(7),
        HoldLow        => thold_RDADDRL_RDCLKL_negedge_posedge(7),
        HoldHigh       => thold_RDADDRL_RDCLKL_posedge_posedge(7),
        CheckEnabled   => TO_X01(rdenl_dly) = '1',
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_RDADDRL8_RDCLKL_posedge,
        TimingData     => Tmkr_RDADDRL8_RDCLKL_posedge,
        TestSignal     => RDADDRL_dly(8),
        TestSignalName => "RDADDRL(8)",
        TestDelay      => tisd_RDADDRL_RDCLKL(8),
        RefSignal      => RDCLKL_dly,
        RefSignalName  => "RDCLKL",
        RefDelay       => ticd_RDCLKL,
        SetupHigh      => tsetup_RDADDRL_RDCLKL_posedge_posedge(8),
        SetupLow       => tsetup_RDADDRL_RDCLKL_negedge_posedge(8),
        HoldLow        => thold_RDADDRL_RDCLKL_negedge_posedge(8),
        HoldHigh       => thold_RDADDRL_RDCLKL_posedge_posedge(8),
        CheckEnabled   => TO_X01(rdenl_dly) = '1',
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_RDADDRL9_RDCLKL_posedge,
        TimingData     => Tmkr_RDADDRL9_RDCLKL_posedge,
        TestSignal     => RDADDRL_dly(9),
        TestSignalName => "RDADDRL(9)",
        TestDelay      => tisd_RDADDRL_RDCLKL(9),
        RefSignal      => RDCLKL_dly,
        RefSignalName  => "RDCLKL",
        RefDelay       => ticd_RDCLKL,
        SetupHigh      => tsetup_RDADDRL_RDCLKL_posedge_posedge(9),
        SetupLow       => tsetup_RDADDRL_RDCLKL_negedge_posedge(9),
        HoldLow        => thold_RDADDRL_RDCLKL_negedge_posedge(9),
        HoldHigh       => thold_RDADDRL_RDCLKL_posedge_posedge(9),
        CheckEnabled   => TO_X01(rdenl_dly) = '1',
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_RDADDRL10_RDCLKL_posedge,
        TimingData     => Tmkr_RDADDRL10_RDCLKL_posedge,
        TestSignal     => RDADDRL_dly(10),
        TestSignalName => "RDADDRL(10)",
        TestDelay      => tisd_RDADDRL_RDCLKL(10),
        RefSignal      => RDCLKL_dly,
        RefSignalName  => "RDCLKL",
        RefDelay       => ticd_RDCLKL,
        SetupHigh      => tsetup_RDADDRL_RDCLKL_posedge_posedge(10),
        SetupLow       => tsetup_RDADDRL_RDCLKL_negedge_posedge(10),
        HoldLow        => thold_RDADDRL_RDCLKL_negedge_posedge(10),
        HoldHigh       => thold_RDADDRL_RDCLKL_posedge_posedge(10),
        CheckEnabled   => TO_X01(rdenl_dly) = '1',
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_RDADDRL11_RDCLKL_posedge,
        TimingData     => Tmkr_RDADDRL11_RDCLKL_posedge,
        TestSignal     => RDADDRL_dly(11),
        TestSignalName => "RDADDRL(11)",
        TestDelay      => tisd_RDADDRL_RDCLKL(11),
        RefSignal      => RDCLKL_dly,
        RefSignalName  => "RDCLKL",
        RefDelay       => ticd_RDCLKL,
        SetupHigh      => tsetup_RDADDRL_RDCLKL_posedge_posedge(11),
        SetupLow       => tsetup_RDADDRL_RDCLKL_negedge_posedge(11),
        HoldLow        => thold_RDADDRL_RDCLKL_negedge_posedge(11),
        HoldHigh       => thold_RDADDRL_RDCLKL_posedge_posedge(11),
        CheckEnabled   => TO_X01(rdenl_dly) = '1',
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_RDADDRL12_RDCLKL_posedge,
        TimingData     => Tmkr_RDADDRL12_RDCLKL_posedge,
        TestSignal     => RDADDRL_dly(12),
        TestSignalName => "RDADDRL(12)",
        TestDelay      => tisd_RDADDRL_RDCLKL(12),
        RefSignal      => RDCLKL_dly,
        RefSignalName  => "RDCLKL",
        RefDelay       => ticd_RDCLKL,
        SetupHigh      => tsetup_RDADDRL_RDCLKL_posedge_posedge(12),
        SetupLow       => tsetup_RDADDRL_RDCLKL_negedge_posedge(12),
        HoldLow        => thold_RDADDRL_RDCLKL_negedge_posedge(12),
        HoldHigh       => thold_RDADDRL_RDCLKL_posedge_posedge(12),
        CheckEnabled   => TO_X01(rdenl_dly) = '1',
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_RDADDRL13_RDCLKL_posedge,
        TimingData     => Tmkr_RDADDRL13_RDCLKL_posedge,
        TestSignal     => RDADDRL_dly(13),
        TestSignalName => "RDADDRL(13)",
        TestDelay      => tisd_RDADDRL_RDCLKL(13),
        RefSignal      => RDCLKL_dly,
        RefSignalName  => "RDCLKL",
        RefDelay       => ticd_RDCLKL,
        SetupHigh      => tsetup_RDADDRL_RDCLKL_posedge_posedge(13),
        SetupLow       => tsetup_RDADDRL_RDCLKL_negedge_posedge(13),
        HoldLow        => thold_RDADDRL_RDCLKL_negedge_posedge(13),
        HoldHigh       => thold_RDADDRL_RDCLKL_posedge_posedge(13),
        CheckEnabled   => TO_X01(rdenl_dly) = '1',
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_RDADDRL14_RDCLKL_posedge,
        TimingData     => Tmkr_RDADDRL14_RDCLKL_posedge,
        TestSignal     => RDADDRL_dly(14),
        TestSignalName => "RDADDRL(14)",
        TestDelay      => tisd_RDADDRL_RDCLKL(14),
        RefSignal      => RDCLKL_dly,
        RefSignalName  => "RDCLKL",
        RefDelay       => ticd_RDCLKL,
        SetupHigh      => tsetup_RDADDRL_RDCLKL_posedge_posedge(14),
        SetupLow       => tsetup_RDADDRL_RDCLKL_negedge_posedge(14),
        HoldLow        => thold_RDADDRL_RDCLKL_negedge_posedge(14),
        HoldHigh       => thold_RDADDRL_RDCLKL_posedge_posedge(14),
        CheckEnabled   => TO_X01(rdenl_dly) = '1',
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_RDADDRL15_RDCLKL_posedge,
        TimingData     => Tmkr_RDADDRL15_RDCLKL_posedge,
        TestSignal     => RDADDRL_dly(15),
        TestSignalName => "RDADDRL(15)",
        TestDelay      => tisd_RDADDRL_RDCLKL(15),
        RefSignal      => RDCLKL_dly,
        RefSignalName  => "RDCLKL",
        RefDelay       => ticd_RDCLKL,
        SetupHigh      => tsetup_RDADDRL_RDCLKL_posedge_posedge(15),
        SetupLow       => tsetup_RDADDRL_RDCLKL_negedge_posedge(15),
        HoldLow        => thold_RDADDRL_RDCLKL_negedge_posedge(15),
        HoldHigh       => thold_RDADDRL_RDCLKL_posedge_posedge(15),
        CheckEnabled   => TO_X01(rdenl_dly) = '1',
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DIP0_WRCLKL_posedge,
        TimingData     => Tmkr_DIP0_WRCLKL_posedge,
        TestSignal     => DIP_dly(0),
        TestSignalName => "DIP(0)",
        TestDelay      => tisd_DIP_WRCLKL(0),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DIP_WRCLKL_posedge_posedge(0),
        SetupLow       => tsetup_DIP_WRCLKL_negedge_posedge(0),
        HoldLow        => thold_DIP_WRCLKL_negedge_posedge(0),
        HoldHigh       => thold_DIP_WRCLKL_posedge_posedge(0),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DIP1_WRCLKL_posedge,
        TimingData     => Tmkr_DIP1_WRCLKL_posedge,
        TestSignal     => DIP_dly(1),
        TestSignalName => "DIP(1)",
        TestDelay      => tisd_DIP_WRCLKL(1),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DIP_WRCLKL_posedge_posedge(1),
        SetupLow       => tsetup_DIP_WRCLKL_negedge_posedge(1),
        HoldLow        => thold_DIP_WRCLKL_negedge_posedge(1),
        HoldHigh       => thold_DIP_WRCLKL_posedge_posedge(1),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DIP2_WRCLKL_posedge,
        TimingData     => Tmkr_DIP2_WRCLKL_posedge,
        TestSignal     => DIP_dly(2),
        TestSignalName => "DIP(2)",
        TestDelay      => tisd_DIP_WRCLKL(2),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DIP_WRCLKL_posedge_posedge(2),
        SetupLow       => tsetup_DIP_WRCLKL_negedge_posedge(2),
        HoldLow        => thold_DIP_WRCLKL_negedge_posedge(2),
        HoldHigh       => thold_DIP_WRCLKL_posedge_posedge(2),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DIP3_WRCLKL_posedge,
        TimingData     => Tmkr_DIP3_WRCLKL_posedge,
        TestSignal     => DIP_dly(3),
        TestSignalName => "DIP(3)",
        TestDelay      => tisd_DIP_WRCLKL(3),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DIP_WRCLKL_posedge_posedge(3),
        SetupLow       => tsetup_DIP_WRCLKL_negedge_posedge(3),
        HoldLow        => thold_DIP_WRCLKL_negedge_posedge(3),
        HoldHigh       => thold_DIP_WRCLKL_posedge_posedge(3),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DIP4_WRCLKL_posedge,
        TimingData     => Tmkr_DIP4_WRCLKL_posedge,
        TestSignal     => DIP_dly(4),
        TestSignalName => "DIP(4)",
        TestDelay      => tisd_DIP_WRCLKL(4),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DIP_WRCLKL_posedge_posedge(4),
        SetupLow       => tsetup_DIP_WRCLKL_negedge_posedge(4),
        HoldLow        => thold_DIP_WRCLKL_negedge_posedge(4),
        HoldHigh       => thold_DIP_WRCLKL_posedge_posedge(4),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DIP5_WRCLKL_posedge,
        TimingData     => Tmkr_DIP5_WRCLKL_posedge,
        TestSignal     => DIP_dly(5),
        TestSignalName => "DIP(5)",
        TestDelay      => tisd_DIP_WRCLKL(5),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DIP_WRCLKL_posedge_posedge(5),
        SetupLow       => tsetup_DIP_WRCLKL_negedge_posedge(5),
        HoldLow        => thold_DIP_WRCLKL_negedge_posedge(5),
        HoldHigh       => thold_DIP_WRCLKL_posedge_posedge(5),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DIP6_WRCLKL_posedge,
        TimingData     => Tmkr_DIP6_WRCLKL_posedge,
        TestSignal     => DIP_dly(6),
        TestSignalName => "DIP(6)",
        TestDelay      => tisd_DIP_WRCLKL(6),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DIP_WRCLKL_posedge_posedge(6),
        SetupLow       => tsetup_DIP_WRCLKL_negedge_posedge(6),
        HoldLow        => thold_DIP_WRCLKL_negedge_posedge(6),
        HoldHigh       => thold_DIP_WRCLKL_posedge_posedge(6),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DIP7_WRCLKL_posedge,
        TimingData     => Tmkr_DIP7_WRCLKL_posedge,
        TestSignal     => DIP_dly(7),
        TestSignalName => "DIP(7)",
        TestDelay      => tisd_DIP_WRCLKL(7),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DIP_WRCLKL_posedge_posedge(7),
        SetupLow       => tsetup_DIP_WRCLKL_negedge_posedge(7),
        HoldLow        => thold_DIP_WRCLKL_negedge_posedge(7),
        HoldHigh       => thold_DIP_WRCLKL_posedge_posedge(7),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI0_WRCLKL_posedge,
        TimingData     => Tmkr_DI0_WRCLKL_posedge,
        TestSignal     => DI_dly(0),
        TestSignalName => "DI(0)",
        TestDelay      => tisd_DI_WRCLKL(0),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(0),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(0),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(0),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(0),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI1_WRCLKL_posedge,
        TimingData     => Tmkr_DI1_WRCLKL_posedge,
        TestSignal     => DI_dly(1),
        TestSignalName => "DI(1)",
        TestDelay      => tisd_DI_WRCLKL(1),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(1),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(1),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(1),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(1),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI2_WRCLKL_posedge,
        TimingData     => Tmkr_DI2_WRCLKL_posedge,
        TestSignal     => DI_dly(2),
        TestSignalName => "DI(2)",
        TestDelay      => tisd_DI_WRCLKL(2),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(2),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(2),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(2),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(2),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI3_WRCLKL_posedge,
        TimingData     => Tmkr_DI3_WRCLKL_posedge,
        TestSignal     => DI_dly(3),
        TestSignalName => "DI(3)",
        TestDelay      => tisd_DI_WRCLKL(3),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(3),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(3),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(3),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(3),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI4_WRCLKL_posedge,
        TimingData     => Tmkr_DI4_WRCLKL_posedge,
        TestSignal     => DI_dly(4),
        TestSignalName => "DI(4)",
        TestDelay      => tisd_DI_WRCLKL(4),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(4),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(4),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(4),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(4),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI5_WRCLKL_posedge,
        TimingData     => Tmkr_DI5_WRCLKL_posedge,
        TestSignal     => DI_dly(5),
        TestSignalName => "DI(5)",
        TestDelay      => tisd_DI_WRCLKL(5),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(5),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(5),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(5),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(5),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI6_WRCLKL_posedge,
        TimingData     => Tmkr_DI6_WRCLKL_posedge,
        TestSignal     => DI_dly(6),
        TestSignalName => "DI(6)",
        TestDelay      => tisd_DI_WRCLKL(6),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(6),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(6),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(6),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(6),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI7_WRCLKL_posedge,
        TimingData     => Tmkr_DI7_WRCLKL_posedge,
        TestSignal     => DI_dly(7),
        TestSignalName => "DI(7)",
        TestDelay      => tisd_DI_WRCLKL(7),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(7),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(7),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(7),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(7),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI8_WRCLKL_posedge,
        TimingData     => Tmkr_DI8_WRCLKL_posedge,
        TestSignal     => DI_dly(8),
        TestSignalName => "DI(8)",
        TestDelay      => tisd_DI_WRCLKL(8),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(8),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(8),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(8),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(8),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI9_WRCLKL_posedge,
        TimingData     => Tmkr_DI9_WRCLKL_posedge,
        TestSignal     => DI_dly(9),
        TestSignalName => "DI(9)",
        TestDelay      => tisd_DI_WRCLKL(9),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(9),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(9),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(9),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(9),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI10_WRCLKL_posedge,
        TimingData     => Tmkr_DI10_WRCLKL_posedge,
        TestSignal     => DI_dly(10),
        TestSignalName => "DI(10)",
        TestDelay      => tisd_DI_WRCLKL(10),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(10),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(10),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(10),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(10),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI11_WRCLKL_posedge,
        TimingData     => Tmkr_DI11_WRCLKL_posedge,
        TestSignal     => DI_dly(11),
        TestSignalName => "DI(11)",
        TestDelay      => tisd_DI_WRCLKL(11),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(11),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(11),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(11),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(11),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI12_WRCLKL_posedge,
        TimingData     => Tmkr_DI12_WRCLKL_posedge,
        TestSignal     => DI_dly(12),
        TestSignalName => "DI(12)",
        TestDelay      => tisd_DI_WRCLKL(12),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(12),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(12),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(12),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(12),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI13_WRCLKL_posedge,
        TimingData     => Tmkr_DI13_WRCLKL_posedge,
        TestSignal     => DI_dly(13),
        TestSignalName => "DI(13)",
        TestDelay      => tisd_DI_WRCLKL(13),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(13),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(13),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(13),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(13),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI14_WRCLKL_posedge,
        TimingData     => Tmkr_DI14_WRCLKL_posedge,
        TestSignal     => DI_dly(14),
        TestSignalName => "DI(14)",
        TestDelay      => tisd_DI_WRCLKL(14),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(14),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(14),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(14),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(14),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI15_WRCLKL_posedge,
        TimingData     => Tmkr_DI15_WRCLKL_posedge,
        TestSignal     => DI_dly(15),
        TestSignalName => "DI(15)",
        TestDelay      => tisd_DI_WRCLKL(15),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(15),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(15),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(15),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(15),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI16_WRCLKL_posedge,
        TimingData     => Tmkr_DI16_WRCLKL_posedge,
        TestSignal     => DI_dly(16),
        TestSignalName => "DI(16)",
        TestDelay      => tisd_DI_WRCLKL(16),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(16),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(16),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(16),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(16),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI17_WRCLKL_posedge,
        TimingData     => Tmkr_DI17_WRCLKL_posedge,
        TestSignal     => DI_dly(17),
        TestSignalName => "DI(17)",
        TestDelay      => tisd_DI_WRCLKL(17),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(17),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(17),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(17),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(17),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI18_WRCLKL_posedge,
        TimingData     => Tmkr_DI18_WRCLKL_posedge,
        TestSignal     => DI_dly(18),
        TestSignalName => "DI(18)",
        TestDelay      => tisd_DI_WRCLKL(18),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(18),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(18),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(18),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(18),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI19_WRCLKL_posedge,
        TimingData     => Tmkr_DI19_WRCLKL_posedge,
        TestSignal     => DI_dly(19),
        TestSignalName => "DI(19)",
        TestDelay      => tisd_DI_WRCLKL(19),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(19),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(19),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(19),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(19),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI20_WRCLKL_posedge,
        TimingData     => Tmkr_DI20_WRCLKL_posedge,
        TestSignal     => DI_dly(20),
        TestSignalName => "DI(20)",
        TestDelay      => tisd_DI_WRCLKL(20),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(20),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(20),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(20),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(20),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI21_WRCLKL_posedge,
        TimingData     => Tmkr_DI21_WRCLKL_posedge,
        TestSignal     => DI_dly(21),
        TestSignalName => "DI(21)",
        TestDelay      => tisd_DI_WRCLKL(21),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(21),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(21),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(21),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(21),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI22_WRCLKL_posedge,
        TimingData     => Tmkr_DI22_WRCLKL_posedge,
        TestSignal     => DI_dly(22),
        TestSignalName => "DI(22)",
        TestDelay      => tisd_DI_WRCLKL(22),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(22),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(22),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(22),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(22),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI23_WRCLKL_posedge,
        TimingData     => Tmkr_DI23_WRCLKL_posedge,
        TestSignal     => DI_dly(23),
        TestSignalName => "DI(23)",
        TestDelay      => tisd_DI_WRCLKL(23),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(23),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(23),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(23),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(23),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI24_WRCLKL_posedge,
        TimingData     => Tmkr_DI24_WRCLKL_posedge,
        TestSignal     => DI_dly(24),
        TestSignalName => "DI(24)",
        TestDelay      => tisd_DI_WRCLKL(24),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(24),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(24),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(24),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(24),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI25_WRCLKL_posedge,
        TimingData     => Tmkr_DI25_WRCLKL_posedge,
        TestSignal     => DI_dly(25),
        TestSignalName => "DI(25)",
        TestDelay      => tisd_DI_WRCLKL(25),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(25),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(25),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(25),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(25),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI26_WRCLKL_posedge,
        TimingData     => Tmkr_DI26_WRCLKL_posedge,
        TestSignal     => DI_dly(26),
        TestSignalName => "DI(26)",
        TestDelay      => tisd_DI_WRCLKL(26),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(26),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(26),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(26),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(26),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI27_WRCLKL_posedge,
        TimingData     => Tmkr_DI27_WRCLKL_posedge,
        TestSignal     => DI_dly(27),
        TestSignalName => "DI(27)",
        TestDelay      => tisd_DI_WRCLKL(27),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(27),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(27),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(27),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(27),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI28_WRCLKL_posedge,
        TimingData     => Tmkr_DI28_WRCLKL_posedge,
        TestSignal     => DI_dly(28),
        TestSignalName => "DI(28)",
        TestDelay      => tisd_DI_WRCLKL(28),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(28),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(28),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(28),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(28),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI29_WRCLKL_posedge,
        TimingData     => Tmkr_DI29_WRCLKL_posedge,
        TestSignal     => DI_dly(29),
        TestSignalName => "DI(29)",
        TestDelay      => tisd_DI_WRCLKL(29),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(29),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(29),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(29),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(29),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI30_WRCLKL_posedge,
        TimingData     => Tmkr_DI30_WRCLKL_posedge,
        TestSignal     => DI_dly(30),
        TestSignalName => "DI(30)",
        TestDelay      => tisd_DI_WRCLKL(30),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(30),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(30),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(30),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(30),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI31_WRCLKL_posedge,
        TimingData     => Tmkr_DI31_WRCLKL_posedge,
        TestSignal     => DI_dly(31),
        TestSignalName => "DI(31)",
        TestDelay      => tisd_DI_WRCLKL(31),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(31),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(31),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(31),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(31),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI32_WRCLKL_posedge,
        TimingData     => Tmkr_DI32_WRCLKL_posedge,
        TestSignal     => DI_dly(32),
        TestSignalName => "DI(32)",
        TestDelay      => tisd_DI_WRCLKL(32),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(32),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(32),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(32),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(32),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI33_WRCLKL_posedge,
        TimingData     => Tmkr_DI33_WRCLKL_posedge,
        TestSignal     => DI_dly(33),
        TestSignalName => "DI(33)",
        TestDelay      => tisd_DI_WRCLKL(33),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(33),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(33),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(33),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(33),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI34_WRCLKL_posedge,
        TimingData     => Tmkr_DI34_WRCLKL_posedge,
        TestSignal     => DI_dly(34),
        TestSignalName => "DI(34)",
        TestDelay      => tisd_DI_WRCLKL(34),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(34),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(34),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(34),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(34),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI35_WRCLKL_posedge,
        TimingData     => Tmkr_DI35_WRCLKL_posedge,
        TestSignal     => DI_dly(35),
        TestSignalName => "DI(35)",
        TestDelay      => tisd_DI_WRCLKL(35),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(35),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(35),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(35),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(35),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI36_WRCLKL_posedge,
        TimingData     => Tmkr_DI36_WRCLKL_posedge,
        TestSignal     => DI_dly(36),
        TestSignalName => "DI(36)",
        TestDelay      => tisd_DI_WRCLKL(36),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(36),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(36),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(36),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(36),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI37_WRCLKL_posedge,
        TimingData     => Tmkr_DI37_WRCLKL_posedge,
        TestSignal     => DI_dly(37),
        TestSignalName => "DI(37)",
        TestDelay      => tisd_DI_WRCLKL(37),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(37),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(37),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(37),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(37),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI38_WRCLKL_posedge,
        TimingData     => Tmkr_DI38_WRCLKL_posedge,
        TestSignal     => DI_dly(38),
        TestSignalName => "DI(38)",
        TestDelay      => tisd_DI_WRCLKL(38),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(38),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(38),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(38),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(38),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI39_WRCLKL_posedge,
        TimingData     => Tmkr_DI39_WRCLKL_posedge,
        TestSignal     => DI_dly(39),
        TestSignalName => "DI(39)",
        TestDelay      => tisd_DI_WRCLKL(39),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(39),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(39),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(39),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(39),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI40_WRCLKL_posedge,
        TimingData     => Tmkr_DI40_WRCLKL_posedge,
        TestSignal     => DI_dly(40),
        TestSignalName => "DI(40)",
        TestDelay      => tisd_DI_WRCLKL(40),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(40),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(40),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(40),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(40),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI41_WRCLKL_posedge,
        TimingData     => Tmkr_DI41_WRCLKL_posedge,
        TestSignal     => DI_dly(41),
        TestSignalName => "DI(41)",
        TestDelay      => tisd_DI_WRCLKL(41),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(41),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(41),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(41),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(41),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI42_WRCLKL_posedge,
        TimingData     => Tmkr_DI42_WRCLKL_posedge,
        TestSignal     => DI_dly(42),
        TestSignalName => "DI(42)",
        TestDelay      => tisd_DI_WRCLKL(42),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(42),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(42),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(42),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(42),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI43_WRCLKL_posedge,
        TimingData     => Tmkr_DI43_WRCLKL_posedge,
        TestSignal     => DI_dly(43),
        TestSignalName => "DI(43)",
        TestDelay      => tisd_DI_WRCLKL(43),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(43),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(43),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(43),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(43),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI44_WRCLKL_posedge,
        TimingData     => Tmkr_DI44_WRCLKL_posedge,
        TestSignal     => DI_dly(44),
        TestSignalName => "DI(44)",
        TestDelay      => tisd_DI_WRCLKL(44),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(44),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(44),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(44),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(44),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI45_WRCLKL_posedge,
        TimingData     => Tmkr_DI45_WRCLKL_posedge,
        TestSignal     => DI_dly(45),
        TestSignalName => "DI(45)",
        TestDelay      => tisd_DI_WRCLKL(45),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(45),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(45),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(45),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(45),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI46_WRCLKL_posedge,
        TimingData     => Tmkr_DI46_WRCLKL_posedge,
        TestSignal     => DI_dly(46),
        TestSignalName => "DI(46)",
        TestDelay      => tisd_DI_WRCLKL(46),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(46),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(46),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(46),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(46),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI47_WRCLKL_posedge,
        TimingData     => Tmkr_DI47_WRCLKL_posedge,
        TestSignal     => DI_dly(47),
        TestSignalName => "DI(47)",
        TestDelay      => tisd_DI_WRCLKL(47),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(47),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(47),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(47),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(47),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI48_WRCLKL_posedge,
        TimingData     => Tmkr_DI48_WRCLKL_posedge,
        TestSignal     => DI_dly(48),
        TestSignalName => "DI(48)",
        TestDelay      => tisd_DI_WRCLKL(48),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(48),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(48),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(48),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(48),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI49_WRCLKL_posedge,
        TimingData     => Tmkr_DI49_WRCLKL_posedge,
        TestSignal     => DI_dly(49),
        TestSignalName => "DI(49)",
        TestDelay      => tisd_DI_WRCLKL(49),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(49),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(49),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(49),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(49),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI50_WRCLKL_posedge,
        TimingData     => Tmkr_DI50_WRCLKL_posedge,
        TestSignal     => DI_dly(50),
        TestSignalName => "DI(50)",
        TestDelay      => tisd_DI_WRCLKL(50),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(50),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(50),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(50),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(50),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI51_WRCLKL_posedge,
        TimingData     => Tmkr_DI51_WRCLKL_posedge,
        TestSignal     => DI_dly(51),
        TestSignalName => "DI(51)",
        TestDelay      => tisd_DI_WRCLKL(51),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(51),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(51),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(51),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(51),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI52_WRCLKL_posedge,
        TimingData     => Tmkr_DI52_WRCLKL_posedge,
        TestSignal     => DI_dly(52),
        TestSignalName => "DI(52)",
        TestDelay      => tisd_DI_WRCLKL(52),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(52),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(52),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(52),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(52),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI53_WRCLKL_posedge,
        TimingData     => Tmkr_DI53_WRCLKL_posedge,
        TestSignal     => DI_dly(53),
        TestSignalName => "DI(53)",
        TestDelay      => tisd_DI_WRCLKL(53),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(53),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(53),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(53),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(53),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI54_WRCLKL_posedge,
        TimingData     => Tmkr_DI54_WRCLKL_posedge,
        TestSignal     => DI_dly(54),
        TestSignalName => "DI(54)",
        TestDelay      => tisd_DI_WRCLKL(54),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(54),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(54),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(54),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(54),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI55_WRCLKL_posedge,
        TimingData     => Tmkr_DI55_WRCLKL_posedge,
        TestSignal     => DI_dly(55),
        TestSignalName => "DI(55)",
        TestDelay      => tisd_DI_WRCLKL(55),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(55),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(55),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(55),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(55),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI56_WRCLKL_posedge,
        TimingData     => Tmkr_DI56_WRCLKL_posedge,
        TestSignal     => DI_dly(56),
        TestSignalName => "DI(56)",
        TestDelay      => tisd_DI_WRCLKL(56),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(56),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(56),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(56),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(56),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI57_WRCLKL_posedge,
        TimingData     => Tmkr_DI57_WRCLKL_posedge,
        TestSignal     => DI_dly(57),
        TestSignalName => "DI(57)",
        TestDelay      => tisd_DI_WRCLKL(57),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(57),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(57),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(57),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(57),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI58_WRCLKL_posedge,
        TimingData     => Tmkr_DI58_WRCLKL_posedge,
        TestSignal     => DI_dly(58),
        TestSignalName => "DI(58)",
        TestDelay      => tisd_DI_WRCLKL(58),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(58),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(58),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(58),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(58),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI59_WRCLKL_posedge,
        TimingData     => Tmkr_DI59_WRCLKL_posedge,
        TestSignal     => DI_dly(59),
        TestSignalName => "DI(59)",
        TestDelay      => tisd_DI_WRCLKL(59),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(59),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(59),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(59),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(59),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI60_WRCLKL_posedge,
        TimingData     => Tmkr_DI60_WRCLKL_posedge,
        TestSignal     => DI_dly(60),
        TestSignalName => "DI(60)",
        TestDelay      => tisd_DI_WRCLKL(60),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(60),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(60),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(60),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(60),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI61_WRCLKL_posedge,
        TimingData     => Tmkr_DI61_WRCLKL_posedge,
        TestSignal     => DI_dly(61),
        TestSignalName => "DI(61)",
        TestDelay      => tisd_DI_WRCLKL(61),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(61),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(61),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(61),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(61),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI62_WRCLKL_posedge,
        TimingData     => Tmkr_DI62_WRCLKL_posedge,
        TestSignal     => DI_dly(62),
        TestSignalName => "DI(62)",
        TestDelay      => tisd_DI_WRCLKL(62),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(62),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(62),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(62),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(62),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_DI63_WRCLKL_posedge,
        TimingData     => Tmkr_DI63_WRCLKL_posedge,
        TestSignal     => DI_dly(63),
        TestSignalName => "DI(63)",
        TestDelay      => tisd_DI_WRCLKL(63),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_DI_WRCLKL_posedge_posedge(63),
        SetupLow       => tsetup_DI_WRCLKL_negedge_posedge(63),
        HoldLow        => thold_DI_WRCLKL_negedge_posedge(63),
        HoldHigh       => thold_DI_WRCLKL_posedge_posedge(63),
        CheckEnabled   => (TO_X01(wrenl_dly)    = '1'),
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_WRENL_WRCLKL_posedge,
        TimingData     => Tmkr_WRENL_WRCLKL_posedge,
        TestSignal     => WRENL_dly,
        TestSignalName => "WRENL",
        TestDelay      => tisd_WRENL_WRCLKL,
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_WRENL_WRCLKL_posedge_posedge,
        SetupLow       => tsetup_WRENL_WRCLKL_negedge_posedge,
        HoldLow        => thold_WRENL_WRCLKL_negedge_posedge,
        HoldHigh       => thold_WRENL_WRCLKL_posedge_posedge,
        CheckEnabled   => true,
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_WEL0_WRCLKL_posedge,
        TimingData     => Tmkr_WEL0_WRCLKL_posedge,
        TestSignal     => WEL_dly(0),
        TestSignalName => "WEL(0)",
        TestDelay      => tisd_WEL_WRCLKL(0),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_WEL_WRCLKL_posedge_posedge(0),
        SetupLow       => tsetup_WEL_WRCLKL_negedge_posedge(0),
        HoldLow        => thold_WEL_WRCLKL_negedge_posedge(0),
        HoldHigh       => thold_WEL_WRCLKL_posedge_posedge(0),
        CheckEnabled   => TO_X01(wrenl_dly) = '1',
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_WEL1_WRCLKL_posedge,
        TimingData     => Tmkr_WEL1_WRCLKL_posedge,
        TestSignal     => WEL_dly(1),
        TestSignalName => "WEL(1)",
        TestDelay      => tisd_WEL_WRCLKL(1),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_WEL_WRCLKL_posedge_posedge(1),
        SetupLow       => tsetup_WEL_WRCLKL_negedge_posedge(1),
        HoldLow        => thold_WEL_WRCLKL_negedge_posedge(1),
        HoldHigh       => thold_WEL_WRCLKL_posedge_posedge(1),
        CheckEnabled   => TO_X01(wrenl_dly) = '1',
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_WEL2_WRCLKL_posedge,
        TimingData     => Tmkr_WEL2_WRCLKL_posedge,
        TestSignal     => WEL_dly(2),
        TestSignalName => "WEL(2)",
        TestDelay      => tisd_WEL_WRCLKL(2),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_WEL_WRCLKL_posedge_posedge(2),
        SetupLow       => tsetup_WEL_WRCLKL_negedge_posedge(2),
        HoldLow        => thold_WEL_WRCLKL_negedge_posedge(2),
        HoldHigh       => thold_WEL_WRCLKL_posedge_posedge(2),
        CheckEnabled   => TO_X01(wrenl_dly) = '1',
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_WEL3_WRCLKL_posedge,
        TimingData     => Tmkr_WEL3_WRCLKL_posedge,
        TestSignal     => WEL_dly(3),
        TestSignalName => "WEL(3)",
        TestDelay      => tisd_WEL_WRCLKL(3),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_WEL_WRCLKL_posedge_posedge(3),
        SetupLow       => tsetup_WEL_WRCLKL_negedge_posedge(3),
        HoldLow        => thold_WEL_WRCLKL_negedge_posedge(3),
        HoldHigh       => thold_WEL_WRCLKL_posedge_posedge(3),
        CheckEnabled   => TO_X01(wrenl_dly) = '1',
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_WEL4_WRCLKL_posedge,
        TimingData     => Tmkr_WEL4_WRCLKL_posedge,
        TestSignal     => WEL_dly(4),
        TestSignalName => "WEL(4)",
        TestDelay      => tisd_WEL_WRCLKL(4),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_WEL_WRCLKL_posedge_posedge(4),
        SetupLow       => tsetup_WEL_WRCLKL_negedge_posedge(4),
        HoldLow        => thold_WEL_WRCLKL_negedge_posedge(4),
        HoldHigh       => thold_WEL_WRCLKL_posedge_posedge(4),
        CheckEnabled   => TO_X01(wrenl_dly) = '1',
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_WEL5_WRCLKL_posedge,
        TimingData     => Tmkr_WEL5_WRCLKL_posedge,
        TestSignal     => WEL_dly(5),
        TestSignalName => "WEL(5)",
        TestDelay      => tisd_WEL_WRCLKL(5),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_WEL_WRCLKL_posedge_posedge(5),
        SetupLow       => tsetup_WEL_WRCLKL_negedge_posedge(5),
        HoldLow        => thold_WEL_WRCLKL_negedge_posedge(5),
        HoldHigh       => thold_WEL_WRCLKL_posedge_posedge(5),
        CheckEnabled   => TO_X01(wrenl_dly) = '1',
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);      
      VitalSetupHoldCheck (
        Violation      => Tviol_WEL6_WRCLKL_posedge,
        TimingData     => Tmkr_WEL6_WRCLKL_posedge,
        TestSignal     => WEL_dly(6),
        TestSignalName => "WEL(6)",
        TestDelay      => tisd_WEL_WRCLKL(6),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_WEL_WRCLKL_posedge_posedge(6),
        SetupLow       => tsetup_WEL_WRCLKL_negedge_posedge(6),
        HoldLow        => thold_WEL_WRCLKL_negedge_posedge(6),
        HoldHigh       => thold_WEL_WRCLKL_posedge_posedge(6),
        CheckEnabled   => TO_X01(wrenl_dly) = '1',
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_WEL7_WRCLKL_posedge,
        TimingData     => Tmkr_WEL7_WRCLKL_posedge,
        TestSignal     => WEL_dly(7),
        TestSignalName => "WEL(7)",
        TestDelay      => tisd_WEL_WRCLKL(7),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_WEL_WRCLKL_posedge_posedge(7),
        SetupLow       => tsetup_WEL_WRCLKL_negedge_posedge(7),
        HoldLow        => thold_WEL_WRCLKL_negedge_posedge(7),
        HoldHigh       => thold_WEL_WRCLKL_posedge_posedge(7),
        CheckEnabled   => TO_X01(wrenl_dly) = '1',
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);      
      VitalSetupHoldCheck (
        Violation      => Tviol_WRADDRL0_WRCLKL_posedge,
        TimingData     => Tmkr_WRADDRL0_WRCLKL_posedge,
        TestSignal     => WRADDRL_dly(0),
        TestSignalName => "WRADDRL(0)",
        TestDelay      => tisd_WRADDRL_WRCLKL(0),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_WRADDRL_WRCLKL_posedge_posedge(0),
        SetupLow       => tsetup_WRADDRL_WRCLKL_negedge_posedge(0),
        HoldLow        => thold_WRADDRL_WRCLKL_negedge_posedge(0),
        HoldHigh       => thold_WRADDRL_WRCLKL_posedge_posedge(0),
        CheckEnabled   => TO_X01(wrenl_dly) = '1',
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_WRADDRL1_WRCLKL_posedge,
        TimingData     => Tmkr_WRADDRL1_WRCLKL_posedge,
        TestSignal     => WRADDRL_dly(1),
        TestSignalName => "WRADDRL(1)",
        TestDelay      => tisd_WRADDRL_WRCLKL(1),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_WRADDRL_WRCLKL_posedge_posedge(1),
        SetupLow       => tsetup_WRADDRL_WRCLKL_negedge_posedge(1),
        HoldLow        => thold_WRADDRL_WRCLKL_negedge_posedge(1),
        HoldHigh       => thold_WRADDRL_WRCLKL_posedge_posedge(1),
        CheckEnabled   => TO_X01(wrenl_dly) = '1',
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_WRADDRL2_WRCLKL_posedge,
        TimingData     => Tmkr_WRADDRL2_WRCLKL_posedge,
        TestSignal     => WRADDRL_dly(2),
        TestSignalName => "WRADDRL(2)",
        TestDelay      => tisd_WRADDRL_WRCLKL(2),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_WRADDRL_WRCLKL_posedge_posedge(2),
        SetupLow       => tsetup_WRADDRL_WRCLKL_negedge_posedge(2),
        HoldLow        => thold_WRADDRL_WRCLKL_negedge_posedge(2),
        HoldHigh       => thold_WRADDRL_WRCLKL_posedge_posedge(2),
        CheckEnabled   => TO_X01(wrenl_dly) = '1',
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_WRADDRL3_WRCLKL_posedge,
        TimingData     => Tmkr_WRADDRL3_WRCLKL_posedge,
        TestSignal     => WRADDRL_dly(3),
        TestSignalName => "WRADDRL(3)",
        TestDelay      => tisd_WRADDRL_WRCLKL(3),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_WRADDRL_WRCLKL_posedge_posedge(3),
        SetupLow       => tsetup_WRADDRL_WRCLKL_negedge_posedge(3),
        HoldLow        => thold_WRADDRL_WRCLKL_negedge_posedge(3),
        HoldHigh       => thold_WRADDRL_WRCLKL_posedge_posedge(3),
        CheckEnabled   => TO_X01(wrenl_dly) = '1',
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_WRADDRL4_WRCLKL_posedge,
        TimingData     => Tmkr_WRADDRL4_WRCLKL_posedge,
        TestSignal     => WRADDRL_dly(4),
        TestSignalName => "WRADDRL(4)",
        TestDelay      => tisd_WRADDRL_WRCLKL(4),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_WRADDRL_WRCLKL_posedge_posedge(4),
        SetupLow       => tsetup_WRADDRL_WRCLKL_negedge_posedge(4),
        HoldLow        => thold_WRADDRL_WRCLKL_negedge_posedge(4),
        HoldHigh       => thold_WRADDRL_WRCLKL_posedge_posedge(4),
        CheckEnabled   => TO_X01(wrenl_dly) = '1',
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_WRADDRL5_WRCLKL_posedge,
        TimingData     => Tmkr_WRADDRL5_WRCLKL_posedge,
        TestSignal     => WRADDRL_dly(5),
        TestSignalName => "WRADDRL(5)",
        TestDelay      => tisd_WRADDRL_WRCLKL(5),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_WRADDRL_WRCLKL_posedge_posedge(5),
        SetupLow       => tsetup_WRADDRL_WRCLKL_negedge_posedge(5),
        HoldLow        => thold_WRADDRL_WRCLKL_negedge_posedge(5),
        HoldHigh       => thold_WRADDRL_WRCLKL_posedge_posedge(5),
        CheckEnabled   => TO_X01(wrenl_dly) = '1',
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_WRADDRL6_WRCLKL_posedge,
        TimingData     => Tmkr_WRADDRL6_WRCLKL_posedge,
        TestSignal     => WRADDRL_dly(6),
        TestSignalName => "WRADDRL(6)",
        TestDelay      => tisd_WRADDRL_WRCLKL(6),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_WRADDRL_WRCLKL_posedge_posedge(6),
        SetupLow       => tsetup_WRADDRL_WRCLKL_negedge_posedge(6),
        HoldLow        => thold_WRADDRL_WRCLKL_negedge_posedge(6),
        HoldHigh       => thold_WRADDRL_WRCLKL_posedge_posedge(6),
        CheckEnabled   => TO_X01(wrenl_dly) = '1',
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_WRADDRL7_WRCLKL_posedge,
        TimingData     => Tmkr_WRADDRL7_WRCLKL_posedge,
        TestSignal     => WRADDRL_dly(7),
        TestSignalName => "WRADDRL(7)",
        TestDelay      => tisd_WRADDRL_WRCLKL(7),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_WRADDRL_WRCLKL_posedge_posedge(7),
        SetupLow       => tsetup_WRADDRL_WRCLKL_negedge_posedge(7),
        HoldLow        => thold_WRADDRL_WRCLKL_negedge_posedge(7),
        HoldHigh       => thold_WRADDRL_WRCLKL_posedge_posedge(7),
        CheckEnabled   => TO_X01(wrenl_dly) = '1',
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_WRADDRL8_WRCLKL_posedge,
        TimingData     => Tmkr_WRADDRL8_WRCLKL_posedge,
        TestSignal     => WRADDRL_dly(8),
        TestSignalName => "WRADDRL(8)",
        TestDelay      => tisd_WRADDRL_WRCLKL(8),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_WRADDRL_WRCLKL_posedge_posedge(8),
        SetupLow       => tsetup_WRADDRL_WRCLKL_negedge_posedge(8),
        HoldLow        => thold_WRADDRL_WRCLKL_negedge_posedge(8),
        HoldHigh       => thold_WRADDRL_WRCLKL_posedge_posedge(8),
        CheckEnabled   => TO_X01(wrenl_dly) = '1',
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_WRADDRL9_WRCLKL_posedge,
        TimingData     => Tmkr_WRADDRL9_WRCLKL_posedge,
        TestSignal     => WRADDRL_dly(9),
        TestSignalName => "WRADDRL(9)",
        TestDelay      => tisd_WRADDRL_WRCLKL(9),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_WRADDRL_WRCLKL_posedge_posedge(9),
        SetupLow       => tsetup_WRADDRL_WRCLKL_negedge_posedge(9),
        HoldLow        => thold_WRADDRL_WRCLKL_negedge_posedge(9),
        HoldHigh       => thold_WRADDRL_WRCLKL_posedge_posedge(9),
        CheckEnabled   => TO_X01(wrenl_dly) = '1',
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_WRADDRL10_WRCLKL_posedge,
        TimingData     => Tmkr_WRADDRL10_WRCLKL_posedge,
        TestSignal     => WRADDRL_dly(10),
        TestSignalName => "WRADDRL(10)",
        TestDelay      => tisd_WRADDRL_WRCLKL(10),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_WRADDRL_WRCLKL_posedge_posedge(10),
        SetupLow       => tsetup_WRADDRL_WRCLKL_negedge_posedge(10),
        HoldLow        => thold_WRADDRL_WRCLKL_negedge_posedge(10),
        HoldHigh       => thold_WRADDRL_WRCLKL_posedge_posedge(10),
        CheckEnabled   => TO_X01(wrenl_dly) = '1',
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_WRADDRL11_WRCLKL_posedge,
        TimingData     => Tmkr_WRADDRL11_WRCLKL_posedge,
        TestSignal     => WRADDRL_dly(11),
        TestSignalName => "WRADDRL(11)",
        TestDelay      => tisd_WRADDRL_WRCLKL(11),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_WRADDRL_WRCLKL_posedge_posedge(11),
        SetupLow       => tsetup_WRADDRL_WRCLKL_negedge_posedge(11),
        HoldLow        => thold_WRADDRL_WRCLKL_negedge_posedge(11),
        HoldHigh       => thold_WRADDRL_WRCLKL_posedge_posedge(11),
        CheckEnabled   => TO_X01(wrenl_dly) = '1',
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_WRADDRL12_WRCLKL_posedge,
        TimingData     => Tmkr_WRADDRL12_WRCLKL_posedge,
        TestSignal     => WRADDRL_dly(12),
        TestSignalName => "WRADDRL(12)",
        TestDelay      => tisd_WRADDRL_WRCLKL(12),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_WRADDRL_WRCLKL_posedge_posedge(12),
        SetupLow       => tsetup_WRADDRL_WRCLKL_negedge_posedge(12),
        HoldLow        => thold_WRADDRL_WRCLKL_negedge_posedge(12),
        HoldHigh       => thold_WRADDRL_WRCLKL_posedge_posedge(12),
        CheckEnabled   => TO_X01(wrenl_dly) = '1',
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_WRADDRL13_WRCLKL_posedge,
        TimingData     => Tmkr_WRADDRL13_WRCLKL_posedge,
        TestSignal     => WRADDRL_dly(13),
        TestSignalName => "WRADDRL(13)",
        TestDelay      => tisd_WRADDRL_WRCLKL(13),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_WRADDRL_WRCLKL_posedge_posedge(13),
        SetupLow       => tsetup_WRADDRL_WRCLKL_negedge_posedge(13),
        HoldLow        => thold_WRADDRL_WRCLKL_negedge_posedge(13),
        HoldHigh       => thold_WRADDRL_WRCLKL_posedge_posedge(13),
        CheckEnabled   => TO_X01(wrenl_dly) = '1',
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_WRADDRL14_WRCLKL_posedge,
        TimingData     => Tmkr_WRADDRL14_WRCLKL_posedge,
        TestSignal     => WRADDRL_dly(14),
        TestSignalName => "WRADDRL(14)",
        TestDelay      => tisd_WRADDRL_WRCLKL(14),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_WRADDRL_WRCLKL_posedge_posedge(14),
        SetupLow       => tsetup_WRADDRL_WRCLKL_negedge_posedge(14),
        HoldLow        => thold_WRADDRL_WRCLKL_negedge_posedge(14),
        HoldHigh       => thold_WRADDRL_WRCLKL_posedge_posedge(14),
        CheckEnabled   => TO_X01(wrenl_dly) = '1',
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalSetupHoldCheck (
        Violation      => Tviol_WRADDRL15_WRCLKL_posedge,
        TimingData     => Tmkr_WRADDRL15_WRCLKL_posedge,
        TestSignal     => WRADDRL_dly(15),
        TestSignalName => "WRADDRL(15)",
        TestDelay      => tisd_WRADDRL_WRCLKL(15),
        RefSignal      => WRCLKL_dly,
        RefSignalName  => "WRCLKL",
        RefDelay       => ticd_WRCLKL,
        SetupHigh      => tsetup_WRADDRL_WRCLKL_posedge_posedge(15),
        SetupLow       => tsetup_WRADDRL_WRCLKL_negedge_posedge(15),
        HoldLow        => thold_WRADDRL_WRCLKL_negedge_posedge(15),
        HoldHigh       => thold_WRADDRL_WRCLKL_posedge_posedge(15),
        CheckEnabled   => TO_X01(wrenl_dly) = '1',
        RefTransition  => 'R',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalPeriodPulseCheck (
        Violation      => Pviol_RDCLKL,
        PeriodData     => PInfo_RDCLKL,
        TestSignal     => RDCLKL_dly,
        TestSignalName => "RDCLKL",
        TestDelay      => 0 ps,
        Period         => tperiod_rdclkl_posedge,
        PulseWidthHigh => tpw_RDCLKL_posedge,
        PulseWidthLow  => tpw_RDCLKL_negedge,
        CheckEnabled   => TO_X01(rdenl_dly) = '1',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalPeriodPulseCheck (
        Violation      => Pviol_WRCLKL,
        PeriodData     => PInfo_WRCLKL,
        TestSignal     => WRCLKL_dly,
        TestSignalName => "WRCLKL",
        TestDelay      => 0 ps,
        Period         => tperiod_wrclkl_posedge,
        PulseWidthHigh => tpw_WRCLKL_posedge,
        PulseWidthLow  => tpw_WRCLKL_negedge,
        CheckEnabled   => TO_X01(wrenl_dly) = '1',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
      VitalPeriodPulseCheck (
        Violation      => Pviol_RDRCLKL,
        PeriodData     => PInfo_RDRCLKL,
        TestSignal     => RDRCLKL_dly,
        TestSignalName => "RDRCLKL",
        TestDelay      => 0 ps,
        Period         => tperiod_rdrclkl_posedge,
        PulseWidthHigh => tpw_RDRCLKL_posedge,
        PulseWidthLow  => tpw_RDRCLKL_negedge,
        CheckEnabled   => TO_X01(rdenl_dly) = '1',
        HeaderMsg      => "/X_RAMB36SDP_EXP",
        Xon            => Xon,
        MsgOn          => MsgOn,
        MsgSeverity    => warning);
    end if;

    Violation         <=
      Tviol_RDADDRL0_RDCLKL_posedge or
      Tviol_RDADDRL1_RDCLKL_posedge or
      Tviol_RDADDRL2_RDCLKL_posedge or
      Tviol_RDADDRL3_RDCLKL_posedge or
      Tviol_RDADDRL4_RDCLKL_posedge or
      Tviol_RDADDRL5_RDCLKL_posedge or
      Tviol_RDADDRL6_RDCLKL_posedge or
      Tviol_RDADDRL7_RDCLKL_posedge or
      Tviol_RDADDRL8_RDCLKL_posedge or
      Tviol_RDADDRL9_RDCLKL_posedge or
      Tviol_RDADDRL10_RDCLKL_posedge or
      Tviol_RDADDRL11_RDCLKL_posedge or
      Tviol_RDADDRL12_RDCLKL_posedge or
      Tviol_RDADDRL13_RDCLKL_posedge or
      Tviol_RDADDRL14_RDCLKL_posedge or
      Tviol_RDADDRL15_RDCLKL_posedge or      
      Tviol_RDENL_RDCLKL_posedge or
      Tviol_SSRL_RDCLKL_posedge or
      Tviol_SSRL_RDRCLKL_posedge or
      Tviol_REGCEL_RDCLKL_posedge or
      Tviol_REGCEL_RDRCLKL_posedge or
      Pviol_RDCLKL or Pviol_RDRCLKL or
      Tviol_WRADDRL0_WRCLKL_posedge or
      Tviol_WRADDRL1_WRCLKL_posedge or
      Tviol_WRADDRL2_WRCLKL_posedge or
      Tviol_WRADDRL3_WRCLKL_posedge or
      Tviol_WRADDRL4_WRCLKL_posedge or
      Tviol_WRADDRL5_WRCLKL_posedge or
      Tviol_WRADDRL6_WRCLKL_posedge or
      Tviol_WRADDRL7_WRCLKL_posedge or
      Tviol_WRADDRL8_WRCLKL_posedge or
      Tviol_WRADDRL9_WRCLKL_posedge or
      Tviol_WRADDRL10_WRCLKL_posedge or
      Tviol_WRADDRL11_WRCLKL_posedge or
      Tviol_WRADDRL12_WRCLKL_posedge or
      Tviol_WRADDRL13_WRCLKL_posedge or
      Tviol_WRADDRL14_WRCLKL_posedge or
      Tviol_WRADDRL15_WRCLKL_posedge or  
      Tviol_DI0_WRCLKL_posedge or
      Tviol_DI1_WRCLKL_posedge or
      Tviol_DI2_WRCLKL_posedge or
      Tviol_DI3_WRCLKL_posedge or
      Tviol_DI4_WRCLKL_posedge or
      Tviol_DI5_WRCLKL_posedge or
      Tviol_DI6_WRCLKL_posedge or
      Tviol_DI7_WRCLKL_posedge or
      Tviol_DI8_WRCLKL_posedge or
      Tviol_DI9_WRCLKL_posedge or
      Tviol_DI10_WRCLKL_posedge or
      Tviol_DI11_WRCLKL_posedge or
      Tviol_DI12_WRCLKL_posedge or
      Tviol_DI13_WRCLKL_posedge or
      Tviol_DI14_WRCLKL_posedge or
      Tviol_DI15_WRCLKL_posedge or
      Tviol_DI16_WRCLKL_posedge or
      Tviol_DI17_WRCLKL_posedge or
      Tviol_DI18_WRCLKL_posedge or
      Tviol_DI19_WRCLKL_posedge or
      Tviol_DI20_WRCLKL_posedge or
      Tviol_DI21_WRCLKL_posedge or
      Tviol_DI22_WRCLKL_posedge or
      Tviol_DI23_WRCLKL_posedge or
      Tviol_DI24_WRCLKL_posedge or
      Tviol_DI25_WRCLKL_posedge or
      Tviol_DI26_WRCLKL_posedge or
      Tviol_DI27_WRCLKL_posedge or
      Tviol_DI28_WRCLKL_posedge or
      Tviol_DI29_WRCLKL_posedge or
      Tviol_DI30_WRCLKL_posedge or
      Tviol_DI31_WRCLKL_posedge or
      Tviol_DI32_WRCLKL_posedge or
      Tviol_DI33_WRCLKL_posedge or
      Tviol_DI34_WRCLKL_posedge or
      Tviol_DI35_WRCLKL_posedge or
      Tviol_DI36_WRCLKL_posedge or
      Tviol_DI37_WRCLKL_posedge or
      Tviol_DI38_WRCLKL_posedge or
      Tviol_DI39_WRCLKL_posedge or
      Tviol_DI40_WRCLKL_posedge or
      Tviol_DI41_WRCLKL_posedge or
      Tviol_DI42_WRCLKL_posedge or
      Tviol_DI43_WRCLKL_posedge or
      Tviol_DI44_WRCLKL_posedge or
      Tviol_DI45_WRCLKL_posedge or
      Tviol_DI46_WRCLKL_posedge or
      Tviol_DI47_WRCLKL_posedge or
      Tviol_DI48_WRCLKL_posedge or
      Tviol_DI49_WRCLKL_posedge or
      Tviol_DI50_WRCLKL_posedge or
      Tviol_DI51_WRCLKL_posedge or
      Tviol_DI52_WRCLKL_posedge or
      Tviol_DI53_WRCLKL_posedge or
      Tviol_DI54_WRCLKL_posedge or
      Tviol_DI55_WRCLKL_posedge or
      Tviol_DI56_WRCLKL_posedge or
      Tviol_DI57_WRCLKL_posedge or
      Tviol_DI58_WRCLKL_posedge or
      Tviol_DI59_WRCLKL_posedge or
      Tviol_DI60_WRCLKL_posedge or
      Tviol_DI61_WRCLKL_posedge or
      Tviol_DI62_WRCLKL_posedge or
      Tviol_DI63_WRCLKL_posedge or
      Tviol_DIP0_WRCLKL_posedge or
      Tviol_DIP1_WRCLKL_posedge or
      Tviol_DIP2_WRCLKL_posedge or
      Tviol_DIP3_WRCLKL_posedge or
      Tviol_DIP4_WRCLKL_posedge or
      Tviol_DIP5_WRCLKL_posedge or
      Tviol_DIP6_WRCLKL_posedge or
      Tviol_DIP7_WRCLKL_posedge or      
      Tviol_WRENL_WRCLKL_posedge or
      Tviol_WEL0_WRCLKL_posedge or
      Tviol_WEL1_WRCLKL_posedge or
      Tviol_WEL2_WRCLKL_posedge or
      Tviol_WEL3_WRCLKL_posedge or
      Tviol_WEL4_WRCLKL_posedge or
      Tviol_WEL5_WRCLKL_posedge or
      Tviol_WEL6_WRCLKL_posedge or
      Tviol_WEL7_WRCLKL_posedge or
      Pviol_WRCLKL;

    if (Tviol_RDADDRL0_RDCLKL_posedge = 'X') then
      	prcd_warn_msg ("RDADDRL(0)", "RDCLKL");
    end if;

    if (Tviol_RDADDRL1_RDCLKL_posedge = 'X') then
      	prcd_warn_msg ("RDADDRL(1)", "RDCLKL");
    end if;

    if (Tviol_RDADDRL2_RDCLKL_posedge = 'X') then
      	prcd_warn_msg ("RDADDRL(2)", "RDCLKL");
    end if;

    if (Tviol_RDADDRL3_RDCLKL_posedge = 'X') then
      	prcd_warn_msg ("RDADDRL(3)", "RDCLKL");
    end if;

    if (Tviol_RDADDRL4_RDCLKL_posedge = 'X') then
      	prcd_warn_msg ("RDADDRL(4)", "RDCLKL");
    end if;

    if (Tviol_RDADDRL5_RDCLKL_posedge = 'X') then
      	prcd_warn_msg ("RDADDRL(5)", "RDCLKL");
    end if;

    if (Tviol_RDADDRL6_RDCLKL_posedge = 'X') then
      	prcd_warn_msg ("RDADDRL(6)", "RDCLKL");
    end if;

    if (Tviol_RDADDRL7_RDCLKL_posedge = 'X') then
      	prcd_warn_msg ("RDADDRL(7)", "RDCLKL");
    end if;

    if (Tviol_RDADDRL8_RDCLKL_posedge = 'X') then
      	prcd_warn_msg ("RDADDRL(8)", "RDCLKL");
    end if;

    if (Tviol_RDADDRL9_RDCLKL_posedge = 'X') then
      	prcd_warn_msg ("RDADDRL(9)", "RDCLKL");
    end if;

    if (Tviol_RDADDRL10_RDCLKL_posedge = 'X') then
      	prcd_warn_msg ("RDADDRL(10)", "RDCLKL");
    end if;

    if (Tviol_RDADDRL11_RDCLKL_posedge = 'X') then
      	prcd_warn_msg ("RDADDRL(11)", "RDCLKL");
    end if;

    if (Tviol_RDADDRL12_RDCLKL_posedge = 'X') then
      	prcd_warn_msg ("RDADDRL(12)", "RDCLKL");
    end if;

    if (Tviol_RDADDRL13_RDCLKL_posedge = 'X') then
      	prcd_warn_msg ("RDADDRL(13)", "RDCLKL");
    end if;

    if (Tviol_RDADDRL14_RDCLKL_posedge = 'X') then
      	prcd_warn_msg ("RDADDRL(14)", "RDCLKL");
    end if;

    if (Tviol_RDADDRL15_RDCLKL_posedge = 'X') then
      	prcd_warn_msg ("RDADDRL(15)", "RDCLKL");
    end if;


    if (Tviol_WRADDRL0_WRCLKL_posedge = 'X') then
      	prcd_warn_msg ("WRADDRL(0)", "WRCLKL");
    end if;

    if (Tviol_WRADDRL1_WRCLKL_posedge = 'X') then
      	prcd_warn_msg ("WRADDRL(1)", "WRCLKL");
    end if;

    if (Tviol_WRADDRL2_WRCLKL_posedge = 'X') then
      	prcd_warn_msg ("WRADDRL(2)", "WRCLKL");
    end if;

    if (Tviol_WRADDRL3_WRCLKL_posedge = 'X') then
      	prcd_warn_msg ("WRADDRL(3)", "WRCLKL");
    end if;

    if (Tviol_WRADDRL4_WRCLKL_posedge = 'X') then
      	prcd_warn_msg ("WRADDRL(4)", "WRCLKL");
    end if;

    if (Tviol_WRADDRL5_WRCLKL_posedge = 'X') then
      	prcd_warn_msg ("WRADDRL(5)", "WRCLKL");
    end if;

    if (Tviol_WRADDRL6_WRCLKL_posedge = 'X') then
      	prcd_warn_msg ("WRADDRL(6)", "WRCLKL");
    end if;

    if (Tviol_WRADDRL7_WRCLKL_posedge = 'X') then
      	prcd_warn_msg ("WRADDRL(7)", "WRCLKL");
    end if;

    if (Tviol_WRADDRL8_WRCLKL_posedge = 'X') then
      	prcd_warn_msg ("WRADDRL(8)", "WRCLKL");
    end if;

    if (Tviol_WRADDRL9_WRCLKL_posedge = 'X') then
      	prcd_warn_msg ("WRADDRL(9)", "WRCLKL");
    end if;

    if (Tviol_WRADDRL10_WRCLKL_posedge = 'X') then
      	prcd_warn_msg ("WRADDRL(10)", "WRCLKL");
    end if;

    if (Tviol_WRADDRL11_WRCLKL_posedge = 'X') then
      	prcd_warn_msg ("WRADDRL(11)", "WRCLKL");
    end if;

    if (Tviol_WRADDRL12_WRCLKL_posedge = 'X') then
      	prcd_warn_msg ("WRADDRL(12)", "WRCLKL");
    end if;

    if (Tviol_WRADDRL13_WRCLKL_posedge = 'X') then
      	prcd_warn_msg ("WRADDRL(13)", "WRCLKL");
    end if;

    if (Tviol_WRADDRL14_WRCLKL_posedge = 'X') then
      	prcd_warn_msg ("WRADDRL(14)", "WRCLKL");
    end if;

    if (Tviol_WRADDRL15_WRCLKL_posedge = 'X') then
      	prcd_warn_msg ("WRADDRL(15)", "WRCLKL");
    end if;
    
      wait on RDADDRL_dly, WRADDRL_dly, RDCLKL_dly, WRCLKL_dly, RDRCLKL_dly, DI_dly, DIP_dly, RDENL_dly, WRENL_dly, SSRL_dly, WEL_dly;
      
  end process;

-------------------------------------------------------------------------------
-- End Timing check
-------------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- Path delay
-------------------------------------------------------------------------------
   prcs_output:process (DO_zd, DOP_zd, SBITERR_zd, DBITERR_zd, ECCPARITY_zd)

    variable rdenl_dly   : std_ulogic                      := 'X';

    variable DO_GlitchData0  : VitalGlitchDataType;
    variable DO_GlitchData1  : VitalGlitchDataType;
    variable DO_GlitchData2  : VitalGlitchDataType;
    variable DO_GlitchData3  : VitalGlitchDataType;
    variable DO_GlitchData4  : VitalGlitchDataType;
    variable DO_GlitchData5  : VitalGlitchDataType;
    variable DO_GlitchData6  : VitalGlitchDataType;
    variable DO_GlitchData7  : VitalGlitchDataType;
    variable DO_GlitchData8  : VitalGlitchDataType;
    variable DO_GlitchData9  : VitalGlitchDataType;
    variable DO_GlitchData10  : VitalGlitchDataType;
    variable DO_GlitchData11  : VitalGlitchDataType;
    variable DO_GlitchData12  : VitalGlitchDataType;
    variable DO_GlitchData13  : VitalGlitchDataType;
    variable DO_GlitchData14  : VitalGlitchDataType;
    variable DO_GlitchData15  : VitalGlitchDataType;
    variable DO_GlitchData16  : VitalGlitchDataType;
    variable DO_GlitchData17  : VitalGlitchDataType;
    variable DO_GlitchData18  : VitalGlitchDataType;
    variable DO_GlitchData19  : VitalGlitchDataType;
    variable DO_GlitchData20  : VitalGlitchDataType;
    variable DO_GlitchData21  : VitalGlitchDataType;
    variable DO_GlitchData22  : VitalGlitchDataType;
    variable DO_GlitchData23  : VitalGlitchDataType;
    variable DO_GlitchData24  : VitalGlitchDataType;
    variable DO_GlitchData25  : VitalGlitchDataType;
    variable DO_GlitchData26  : VitalGlitchDataType;
    variable DO_GlitchData27  : VitalGlitchDataType;
    variable DO_GlitchData28  : VitalGlitchDataType;
    variable DO_GlitchData29  : VitalGlitchDataType;
    variable DO_GlitchData30  : VitalGlitchDataType;
    variable DO_GlitchData31  : VitalGlitchDataType;
    variable DO_GlitchData32  : VitalGlitchDataType;
    variable DO_GlitchData33  : VitalGlitchDataType;
    variable DO_GlitchData34  : VitalGlitchDataType;
    variable DO_GlitchData35  : VitalGlitchDataType;
    variable DO_GlitchData36  : VitalGlitchDataType;
    variable DO_GlitchData37  : VitalGlitchDataType;
    variable DO_GlitchData38  : VitalGlitchDataType;
    variable DO_GlitchData39  : VitalGlitchDataType;
    variable DO_GlitchData40  : VitalGlitchDataType;
    variable DO_GlitchData41  : VitalGlitchDataType;
    variable DO_GlitchData42  : VitalGlitchDataType;
    variable DO_GlitchData43  : VitalGlitchDataType;
    variable DO_GlitchData44  : VitalGlitchDataType;
    variable DO_GlitchData45  : VitalGlitchDataType;
    variable DO_GlitchData46  : VitalGlitchDataType;
    variable DO_GlitchData47  : VitalGlitchDataType;
    variable DO_GlitchData48  : VitalGlitchDataType;
    variable DO_GlitchData49  : VitalGlitchDataType;
    variable DO_GlitchData50  : VitalGlitchDataType;
    variable DO_GlitchData51  : VitalGlitchDataType;
    variable DO_GlitchData52  : VitalGlitchDataType;
    variable DO_GlitchData53  : VitalGlitchDataType;
    variable DO_GlitchData54  : VitalGlitchDataType;
    variable DO_GlitchData55  : VitalGlitchDataType;
    variable DO_GlitchData56  : VitalGlitchDataType;
    variable DO_GlitchData57  : VitalGlitchDataType;
    variable DO_GlitchData58  : VitalGlitchDataType;
    variable DO_GlitchData59  : VitalGlitchDataType;
    variable DO_GlitchData60  : VitalGlitchDataType;
    variable DO_GlitchData61  : VitalGlitchDataType;
    variable DO_GlitchData62  : VitalGlitchDataType;
    variable DO_GlitchData63  : VitalGlitchDataType;    
    variable DOP_GlitchData0 : VitalGlitchDataType;
    variable DOP_GlitchData1 : VitalGlitchDataType;
    variable DOP_GlitchData2 : VitalGlitchDataType;
    variable DOP_GlitchData3 : VitalGlitchDataType;
    variable DOP_GlitchData4 : VitalGlitchDataType;
    variable DOP_GlitchData5 : VitalGlitchDataType;
    variable DOP_GlitchData6 : VitalGlitchDataType;
    variable DOP_GlitchData7 : VitalGlitchDataType;
    variable ECCPARITY_GlitchData0 : VitalGlitchDataType;
    variable ECCPARITY_GlitchData1 : VitalGlitchDataType;
    variable ECCPARITY_GlitchData2 : VitalGlitchDataType;
    variable ECCPARITY_GlitchData3 : VitalGlitchDataType;
    variable ECCPARITY_GlitchData4 : VitalGlitchDataType;
    variable ECCPARITY_GlitchData5 : VitalGlitchDataType;
    variable ECCPARITY_GlitchData6 : VitalGlitchDataType;
    variable ECCPARITY_GlitchData7 : VitalGlitchDataType;
    variable DBITERR_GlitchData : VitalGlitchDataType;
    variable SBITERR_GlitchData : VitalGlitchDataType;    
    variable DO_viol     : std_logic_vector(MAX_DI downto 0);
    variable DOP_viol    : std_logic_vector(MAX_DIP downto 0);
    variable ECCPARITY_viol    : std_logic_vector(7 downto 0);
    variable DBITERR_viol     : std_ulogic;
    variable SBITERR_viol     : std_ulogic;
    
 begin

    DO_viol(0)  := Violation xor DO_zd(0);
    DO_viol(1)  := Violation xor DO_zd(1);
    DO_viol(2)  := Violation xor DO_zd(2);
    DO_viol(3)  := Violation xor DO_zd(3);
    DO_viol(4)  := Violation xor DO_zd(4);
    DO_viol(5)  := Violation xor DO_zd(5);
    DO_viol(6)  := Violation xor DO_zd(6);
    DO_viol(7)  := Violation xor DO_zd(7);
    DO_viol(8)  := Violation xor DO_zd(8);
    DO_viol(9)  := Violation xor DO_zd(9);
    DO_viol(10) := Violation xor DO_zd(10);
    DO_viol(11) := Violation xor DO_zd(11);
    DO_viol(12) := Violation xor DO_zd(12);
    DO_viol(13) := Violation xor DO_zd(13);
    DO_viol(14) := Violation xor DO_zd(14);
    DO_viol(15) := Violation xor DO_zd(15);
    DO_viol(16) := Violation xor DO_zd(16);
    DO_viol(17) := Violation xor DO_zd(17);
    DO_viol(18) := Violation xor DO_zd(18);
    DO_viol(19) := Violation xor DO_zd(19);
    DO_viol(20) := Violation xor DO_zd(20);
    DO_viol(21) := Violation xor DO_zd(21);
    DO_viol(22) := Violation xor DO_zd(22);
    DO_viol(23) := Violation xor DO_zd(23);
    DO_viol(24) := Violation xor DO_zd(24);
    DO_viol(25) := Violation xor DO_zd(25);
    DO_viol(26) := Violation xor DO_zd(26);
    DO_viol(27) := Violation xor DO_zd(27);
    DO_viol(28) := Violation xor DO_zd(28);
    DO_viol(29) := Violation xor DO_zd(29);
    DO_viol(30) := Violation xor DO_zd(30);
    DO_viol(31) := Violation xor DO_zd(31);
    DO_viol(32) := Violation xor DO_zd(32);
    DO_viol(33) := Violation xor DO_zd(33);
    DO_viol(34) := Violation xor DO_zd(34);
    DO_viol(35) := Violation xor DO_zd(35);
    DO_viol(36) := Violation xor DO_zd(36);
    DO_viol(37) := Violation xor DO_zd(37);
    DO_viol(38) := Violation xor DO_zd(38);
    DO_viol(39) := Violation xor DO_zd(39);    
    DO_viol(40) := Violation xor DO_zd(40);
    DO_viol(41) := Violation xor DO_zd(41);
    DO_viol(42) := Violation xor DO_zd(42);
    DO_viol(43) := Violation xor DO_zd(43);
    DO_viol(44) := Violation xor DO_zd(44);
    DO_viol(45) := Violation xor DO_zd(45);
    DO_viol(46) := Violation xor DO_zd(46);
    DO_viol(47) := Violation xor DO_zd(47);
    DO_viol(48) := Violation xor DO_zd(48);
    DO_viol(49) := Violation xor DO_zd(49);  
    DO_viol(50) := Violation xor DO_zd(50);
    DO_viol(51) := Violation xor DO_zd(51);
    DO_viol(52) := Violation xor DO_zd(52);
    DO_viol(53) := Violation xor DO_zd(53);
    DO_viol(54) := Violation xor DO_zd(54);
    DO_viol(55) := Violation xor DO_zd(55);
    DO_viol(56) := Violation xor DO_zd(56);
    DO_viol(57) := Violation xor DO_zd(57);
    DO_viol(58) := Violation xor DO_zd(58);
    DO_viol(59) := Violation xor DO_zd(59);
    DO_viol(60) := Violation xor DO_zd(60);
    DO_viol(61) := Violation xor DO_zd(61);
    DO_viol(62) := Violation xor DO_zd(62);
    DO_viol(63) := Violation xor DO_zd(63);
    
    DOP_viol(0) := Violation xor DOP_zd(0);
    DOP_viol(1) := Violation xor DOP_zd(1);
    DOP_viol(2) := Violation xor DOP_zd(2);
    DOP_viol(3) := Violation xor DOP_zd(3);
    DOP_viol(4) := Violation xor DOP_zd(4);
    DOP_viol(5) := Violation xor DOP_zd(5);
    DOP_viol(6) := Violation xor DOP_zd(6);
    DOP_viol(7) := Violation xor DOP_zd(7);

    DBITERR_viol := Violation xor DBITERR_zd;
    SBITERR_viol := Violation xor SBITERR_zd;

    ECCPARITY_viol(0) := Violation xor ECCPARITY_zd(0);
    ECCPARITY_viol(1) := Violation xor ECCPARITY_zd(1);
    ECCPARITY_viol(2) := Violation xor ECCPARITY_zd(2);
    ECCPARITY_viol(3) := Violation xor ECCPARITY_zd(3);
    ECCPARITY_viol(4) := Violation xor ECCPARITY_zd(4);
    ECCPARITY_viol(5) := Violation xor ECCPARITY_zd(5);
    ECCPARITY_viol(6) := Violation xor ECCPARITY_zd(6);
    ECCPARITY_viol(7) := Violation xor ECCPARITY_zd(7);
    
    rdenl_dly   := RDENL_dly;

    VitalPathDelay01 (
      OutSignal     => DO(0),
      GlitchData    => DO_GlitchData0,
      OutSignalName => "DO(0)",
      OutTemp       => DO_viol(0),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(0), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(0), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(1),
      GlitchData    => DO_GlitchData1,
      OutSignalName => "DO(1)",
      OutTemp       => DO_viol(1),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(1), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(1), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(2),
      GlitchData    => DO_GlitchData2,
      OutSignalName => "DO(2)",
      OutTemp       => DO_viol(2),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(2), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(2), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(3),
      GlitchData    => DO_GlitchData3,
      OutSignalName => "DO(3)",
      OutTemp       => DO_viol(3),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(3), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(3), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(4),
      GlitchData    => DO_GlitchData4,
      OutSignalName => "DO(4)",
      OutTemp       => DO_viol(4),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(4), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(4), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(5),
      GlitchData    => DO_GlitchData5,
      OutSignalName => "DO(5)",
      OutTemp       => DO_viol(5),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(5), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(5), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(6),
      GlitchData    => DO_GlitchData6,
      OutSignalName => "DO(6)",
      OutTemp       => DO_viol(6),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(6), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(6), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(7),
      GlitchData    => DO_GlitchData7,
      OutSignalName => "DO(7)",
      OutTemp       => DO_viol(7),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(7), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(7), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(8),
      GlitchData    => DO_GlitchData8,
      OutSignalName => "DO(8)",
      OutTemp       => DO_viol(8),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(8), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(8), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(9),
      GlitchData    => DO_GlitchData9,
      OutSignalName => "DO(9)",
      OutTemp       => DO_viol(9),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(9), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(9), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(10),
      GlitchData    => DO_GlitchData10,
      OutSignalName => "DO(10)",
      OutTemp       => DO_viol(10),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(10), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(10), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(11),
      GlitchData    => DO_GlitchData11,
      OutSignalName => "DO(11)",
      OutTemp       => DO_viol(11),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(11), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(11), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(12),
      GlitchData    => DO_GlitchData12,
      OutSignalName => "DO(12)",
      OutTemp       => DO_viol(12),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(12), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(12), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(13),
      GlitchData    => DO_GlitchData13,
      OutSignalName => "DO(13)",
      OutTemp       => DO_viol(13),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(13), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(13), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(14),
      GlitchData    => DO_GlitchData14,
      OutSignalName => "DO(14)",
      OutTemp       => DO_viol(14),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(14), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(14), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(15),
      GlitchData    => DO_GlitchData15,
      OutSignalName => "DO(15)",
      OutTemp       => DO_viol(15),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(15), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(15), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(16),
      GlitchData    => DO_GlitchData16,
      OutSignalName => "DO(16)",
      OutTemp       => DO_viol(16),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(16), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(16), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(17),
      GlitchData    => DO_GlitchData17,
      OutSignalName => "DO(17)",
      OutTemp       => DO_viol(17),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(17), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(17), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(18),
      GlitchData    => DO_GlitchData18,
      OutSignalName => "DO(18)",
      OutTemp       => DO_viol(18),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(18), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(18), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(19),
      GlitchData    => DO_GlitchData19,
      OutSignalName => "DO(19)",
      OutTemp       => DO_viol(19),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(19), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(19), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(20),
      GlitchData    => DO_GlitchData20,
      OutSignalName => "DO(20)",
      OutTemp       => DO_viol(20),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(20), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(20), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(21),
      GlitchData    => DO_GlitchData21,
      OutSignalName => "DO(21)",
      OutTemp       => DO_viol(21),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(21), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(21), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(22),
      GlitchData    => DO_GlitchData22,
      OutSignalName => "DO(22)",
      OutTemp       => DO_viol(22),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(22), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(22), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(23),
      GlitchData    => DO_GlitchData23,
      OutSignalName => "DO(23)",
      OutTemp       => DO_viol(23),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(23), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(23), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(24),
      GlitchData    => DO_GlitchData24,
      OutSignalName => "DO(24)",
      OutTemp       => DO_viol(24),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(24), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(24), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(25),
      GlitchData    => DO_GlitchData25,
      OutSignalName => "DO(25)",
      OutTemp       => DO_viol(25),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(25), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(25), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(26),
      GlitchData    => DO_GlitchData26,
      OutSignalName => "DO(26)",
      OutTemp       => DO_viol(26),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(26), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(26), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))), 
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(27),
      GlitchData    => DO_GlitchData27,
      OutSignalName => "DO(27)",
      OutTemp       => DO_viol(27),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(27), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(27), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(28),
      GlitchData    => DO_GlitchData28,
      OutSignalName => "DO(28)",
      OutTemp       => DO_viol(28),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(28), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(28), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(29),
      GlitchData    => DO_GlitchData29,
      OutSignalName => "DO(29)",
      OutTemp       => DO_viol(29),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(29), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(29), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(30),
      GlitchData    => DO_GlitchData30,
      OutSignalName => "DO(30)",
      OutTemp       => DO_viol(30),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(30), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(30), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(31),
      GlitchData    => DO_GlitchData31,
      OutSignalName => "DO(31)",
      OutTemp       => DO_viol(31),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(31), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(31), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(32),
      GlitchData    => DO_GlitchData32,
      OutSignalName => "DO(32)",
      OutTemp       => DO_viol(32),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(32), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(32), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(33),
      GlitchData    => DO_GlitchData33,
      OutSignalName => "DO(33)",
      OutTemp       => DO_viol(33),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(33), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(33), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(34),
      GlitchData    => DO_GlitchData34,
      OutSignalName => "DO(34)",
      OutTemp       => DO_viol(34),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(34), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(34), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(35),
      GlitchData    => DO_GlitchData35,
      OutSignalName => "DO(35)",
      OutTemp       => DO_viol(35),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(35), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(35), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(36),
      GlitchData    => DO_GlitchData36,
      OutSignalName => "DO(36)",
      OutTemp       => DO_viol(36),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(36), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(36), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(37),
      GlitchData    => DO_GlitchData37,
      OutSignalName => "DO(37)",
      OutTemp       => DO_viol(37),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(37), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(37), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(38),
      GlitchData    => DO_GlitchData38,
      OutSignalName => "DO(38)",
      OutTemp       => DO_viol(38),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(38), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(38), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(39),
      GlitchData    => DO_GlitchData39,
      OutSignalName => "DO(39)",
      OutTemp       => DO_viol(39),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(39), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(39), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(40),
      GlitchData    => DO_GlitchData40,
      OutSignalName => "DO(40)",
      OutTemp       => DO_viol(40),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(40), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(40), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(41),
      GlitchData    => DO_GlitchData41,
      OutSignalName => "DO(41)",
      OutTemp       => DO_viol(41),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(41), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(41), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(42),
      GlitchData    => DO_GlitchData42,
      OutSignalName => "DO(42)",
      OutTemp       => DO_viol(42),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(42), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(42), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(43),
      GlitchData    => DO_GlitchData43,
      OutSignalName => "DO(43)",
      OutTemp       => DO_viol(43),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(43), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(43), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(44),
      GlitchData    => DO_GlitchData44,
      OutSignalName => "DO(44)",
      OutTemp       => DO_viol(44),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(44), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(44), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(45),
      GlitchData    => DO_GlitchData45,
      OutSignalName => "DO(45)",
      OutTemp       => DO_viol(45),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(45), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(45), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(46),
      GlitchData    => DO_GlitchData46,
      OutSignalName => "DO(46)",
      OutTemp       => DO_viol(46),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(46), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(46), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(47),
      GlitchData    => DO_GlitchData47,
      OutSignalName => "DO(47)",
      OutTemp       => DO_viol(47),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(47), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(47), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(48),
      GlitchData    => DO_GlitchData48,
      OutSignalName => "DO(48)",
      OutTemp       => DO_viol(48),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(48), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(48), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(49),
      GlitchData    => DO_GlitchData49,
      OutSignalName => "DO(49)",
      OutTemp       => DO_viol(49),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(49), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(49), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(50),
      GlitchData    => DO_GlitchData50,
      OutSignalName => "DO(50)",
      OutTemp       => DO_viol(50),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(50), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(50), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(51),
      GlitchData    => DO_GlitchData51,
      OutSignalName => "DO(51)",
      OutTemp       => DO_viol(51),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(51), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(51), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(52),
      GlitchData    => DO_GlitchData52,
      OutSignalName => "DO(52)",
      OutTemp       => DO_viol(52),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(52), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(52), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(53),
      GlitchData    => DO_GlitchData53,
      OutSignalName => "DO(53)",
      OutTemp       => DO_viol(53),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(53), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(53), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(54),
      GlitchData    => DO_GlitchData54,
      OutSignalName => "DO(54)",
      OutTemp       => DO_viol(54),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(54), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(54), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(55),
      GlitchData    => DO_GlitchData55,
      OutSignalName => "DO(55)",
      OutTemp       => DO_viol(55),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(55), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(55), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(56),
      GlitchData    => DO_GlitchData56,
      OutSignalName => "DO(56)",
      OutTemp       => DO_viol(56),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(56), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(56), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(57),
      GlitchData    => DO_GlitchData57,
      OutSignalName => "DO(57)",
      OutTemp       => DO_viol(57),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(57), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(57), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(58),
      GlitchData    => DO_GlitchData58,
      OutSignalName => "DO(58)",
      OutTemp       => DO_viol(58),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(58), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(58), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(59),
      GlitchData    => DO_GlitchData59,
      OutSignalName => "DO(59)",
      OutTemp       => DO_viol(59),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(59), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(59), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(60),
      GlitchData    => DO_GlitchData60,
      OutSignalName => "DO(60)",
      OutTemp       => DO_viol(60),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(60), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(60), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(61),
      GlitchData    => DO_GlitchData61,
      OutSignalName => "DO(61)",
      OutTemp       => DO_viol(61),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(61), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(61), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(62),
      GlitchData    => DO_GlitchData62,
      OutSignalName => "DO(62)",
      OutTemp       => DO_viol(62),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(62), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(62), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DO(63),
      GlitchData    => DO_GlitchData63,
      OutSignalName => "DO(63)",
      OutTemp       => DO_viol(63),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DO(63), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1')),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DO(63), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DOP(0),
      GlitchData    => DOP_GlitchData0,
      OutSignalName => "DOP(0)",
      OutTemp       => DOP_viol(0),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DOP(0), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1' )),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DOP(0), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DOP(1),
      GlitchData    => DOP_GlitchData1,
      OutSignalName => "DOP(1)",
      OutTemp       => DOP_viol(1),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DOP(1), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1' )),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DOP(1), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DOP(2),
      GlitchData    => DOP_GlitchData2,
      OutSignalName => "DOP(2)",
      OutTemp       => DOP_viol(2),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DOP(2), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1' )),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DOP(2), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DOP(3),
      GlitchData    => DOP_GlitchData3,
      OutSignalName => "DOP(3)",
      OutTemp       => DOP_viol(3),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DOP(3), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1' )),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DOP(3), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DOP(4),
      GlitchData    => DOP_GlitchData4,
      OutSignalName => "DOP(4)",
      OutTemp       => DOP_viol(4),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DOP(4), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1' )),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DOP(4), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DOP(5),
      GlitchData    => DOP_GlitchData5,
      OutSignalName => "DOP(5)",
      OutTemp       => DOP_viol(5),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DOP(5), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1' )),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DOP(5), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DOP(6),
      GlitchData    => DOP_GlitchData6,
      OutSignalName => "DOP(6)",
      OutTemp       => DOP_viol(6),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DOP(6), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1' )),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DOP(6), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DOP(7),
      GlitchData    => DOP_GlitchData7,
      OutSignalName => "DOP(7)",
      OutTemp       => DOP_viol(7),
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DOP(7), (rdenl_dly /= '0' and GSR_RDCLKL_dly /= '1' )),
                        1 => (RDRCLKL_dly'last_event, tpd_RDRCLKL_DOP(7), (rdenl_dly /= '0' and GSR_RDRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => ECCPARITY(0),
      GlitchData    => ECCPARITY_GlitchData0,
      OutSignalName => "ECCPARITY(0)",
      OutTemp       => ECCPARITY_viol(0),
      Paths         => (0 => (WRCLKL_dly'last_event, tpd_WRCLKL_ECCPARITY(0), (GSR_WRCLKL_dly /= '1' ))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => ECCPARITY(1),
      GlitchData    => ECCPARITY_GlitchData1,
      OutSignalName => "ECCPARITY(1)",
      OutTemp       => ECCPARITY_viol(1),
      Paths         => (0 => (WRCLKL_dly'last_event, tpd_WRCLKL_ECCPARITY(1), (GSR_WRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => ECCPARITY(2),
      GlitchData    => ECCPARITY_GlitchData2,
      OutSignalName => "ECCPARITY(2)",
      OutTemp       => ECCPARITY_viol(2),
      Paths         => (0 => (WRCLKL_dly'last_event, tpd_WRCLKL_ECCPARITY(2), (GSR_WRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => ECCPARITY(3),
      GlitchData    => ECCPARITY_GlitchData3,
      OutSignalName => "ECCPARITY(3)",
      OutTemp       => ECCPARITY_viol(3),
      Paths         => (0 => (WRCLKL_dly'last_event, tpd_WRCLKL_ECCPARITY(3), (GSR_WRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => ECCPARITY(4),
      GlitchData    => ECCPARITY_GlitchData4,
      OutSignalName => "ECCPARITY(4)",
      OutTemp       => ECCPARITY_viol(4),
      Paths         => (0 => (WRCLKL_dly'last_event, tpd_WRCLKL_ECCPARITY(4), (GSR_WRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => ECCPARITY(5),
      GlitchData    => ECCPARITY_GlitchData5,
      OutSignalName => "ECCPARITY(5)",
      OutTemp       => ECCPARITY_viol(5),
      Paths         => (0 => (WRCLKL_dly'last_event, tpd_WRCLKL_ECCPARITY(5), (GSR_WRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => ECCPARITY(6),
      GlitchData    => ECCPARITY_GlitchData6,
      OutSignalName => "ECCPARITY(6)",
      OutTemp       => ECCPARITY_viol(6),
      Paths         => (0 => (WRCLKL_dly'last_event, tpd_WRCLKL_ECCPARITY(6), (GSR_WRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => ECCPARITY(7),
      GlitchData    => ECCPARITY_GlitchData7,
      OutSignalName => "ECCPARITY(7)",
      OutTemp       => ECCPARITY_viol(7),
      Paths         => (0 => (WRCLKL_dly'last_event, tpd_WRCLKL_ECCPARITY(7), (GSR_WRCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => DBITERR,
      GlitchData    => DBITERR_GlitchData,
      OutSignalName => "DBITERR",
      OutTemp       => DBITERR_viol,
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_DBITERR, (GSR_RDCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    VitalPathDelay01 (
      OutSignal     => SBITERR,
      GlitchData    => SBITERR_GlitchData,
      OutSignalName => "SBITERR",
      OutTemp       => SBITERR_viol,
      Paths         => (0 => (RDCLKL_dly'last_event, tpd_RDCLKL_SBITERR, (GSR_RDCLKL_dly /= '1'))),
      Mode          => VitalTransport,
      Xon           => Xon,
      MsgOn         => MsgOn,
      MsgSeverity   => warning);
    
   end process prcs_output;
---------------------------------------------------------------------------
-- End Path delay
---------------------------------------------------------------------------
  
end X_RAMB36SDP_EXP_V;
